/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.mail.AbstractAddressFormatterTest;
import org.openvpms.web.component.mail.AddressFormatter;
import org.openvpms.web.component.mail.FromAddressFormatter;

public class FromAddressFormatterTestCase
extends AbstractAddressFormatterTest {
    @Override
    @Test
    public void testFormat() {
        FromAddressFormatter formatter = new FromAddressFormatter();
        Party location = (Party)this.create("party.organisationLocation", Party.class);
        location.setName("Main Clinic");
        Contact email = TestHelper.createEmailContact((String)"main@clinic.com");
        location.addContact(email);
        Assert.assertEquals((Object)"Main Clinic <main@clinic.com>", (Object)formatter.format(email));
        email.setName("Main Clinic Accounts");
        Assert.assertEquals((Object)"Main Clinic Accounts (Main Clinic) <main@clinic.com>", (Object)formatter.format(email));
    }

    @Override
    protected AddressFormatter createAddressFormatter() {
        return new FromAddressFormatter();
    }
}

