/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.mail.AddressFormatter;

public abstract class AbstractAddressFormatterTest
extends ArchetypeServiceTest {
    private AddressFormatter formatter;
    private Contact email;

    @Before
    public void setUp() {
        this.formatter = this.createAddressFormatter();
        Party customer = TestHelper.createCustomer((String)"Foo", (String)"Bar", (boolean)false);
        this.getArchetypeService().deriveValues((IMObject)customer);
        IMObjectBean bean = this.getBean((IMObject)customer);
        Lookup mr = TestHelper.getLookup((String)"lookup.personTitle", (String)"MR");
        bean.setValue("title", (Object)mr.getCode());
        this.email = TestHelper.createEmailContact((String)"foo@bar.com");
        customer.addContact(this.email);
    }

    @Test
    public void testGetAddress() {
        Assert.assertNull((Object)this.formatter.getAddress(null));
        Assert.assertEquals((Object)"foo@bar.com", (Object)this.formatter.getAddress(this.email));
    }

    @Test
    public void testGetName() {
        Assert.assertEquals((Object)"Bar,Foo", (Object)this.formatter.getName(this.email));
        this.email.setName("Foo Bar");
        Assert.assertEquals((Object)"Foo Bar", (Object)this.formatter.getName(this.email));
    }

    @Test
    public void testGetQualifiedName() {
        Assert.assertEquals((Object)"Bar,Foo", (Object)this.formatter.getQualifiedName(this.email));
        this.email.setName("Foo Bar");
        Assert.assertEquals((Object)"Foo Bar (Bar,Foo)", (Object)this.formatter.getQualifiedName(this.email));
    }

    @Test
    public void testGetNameAddress() {
        Assert.assertEquals((Object)"Bar,Foo <foo@bar.com>", (Object)this.formatter.getNameAddress(this.email, false));
        Assert.assertEquals((Object)"\"Bar,Foo\" <foo@bar.com>", (Object)this.formatter.getNameAddress(this.email, true));
        this.email.setName("Foo Bar");
        Assert.assertEquals((Object)"Foo Bar <foo@bar.com>", (Object)this.formatter.getNameAddress(this.email, false));
        Assert.assertEquals((Object)"\"Foo Bar\" <foo@bar.com>", (Object)this.formatter.getNameAddress(this.email, true));
    }

    @Test
    public void testFormat() {
        Assert.assertEquals((Object)"Bar,Foo <foo@bar.com> - Customer", (Object)this.formatter.format(this.email));
        this.email.setName("Foo Bar");
        Assert.assertEquals((Object)"Foo Bar (Bar,Foo) <foo@bar.com> - Customer", (Object)this.formatter.format(this.email));
    }

    @Test
    public void testGetType() {
        Assert.assertEquals((Object)"Customer", (Object)this.formatter.getType(this.email));
    }

    protected abstract AddressFormatter createAddressFormatter();
}

