/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.macro;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.macro.MacroVariables;

public class MacroVariableTestCase
extends ArchetypeServiceTest {
    private Context context;
    private Party practice;
    private Party location;
    private Party customer;
    private Party patient;
    private User clinician;
    private Party till;
    private Party depositAccount;
    private User user;
    private Party stockLocation;
    private IMObject invoice;
    private IMObject visit;

    @Before
    public void setUp() {
        this.context = new LocalContext();
        this.practice = (Party)this.create("party.organisationPractice", Party.class);
        this.context.setPractice(this.practice);
        this.location = (Party)this.create("party.organisationLocation", Party.class);
        this.context.setLocation(this.location);
        this.stockLocation = (Party)this.create("party.organisationStockLocation", Party.class);
        this.context.setStockLocation(this.stockLocation);
        this.customer = (Party)this.create("party.customerperson", Party.class);
        this.context.setCustomer(this.customer);
        this.patient = (Party)this.create("party.patientpet", Party.class);
        this.context.setPatient(this.patient);
        this.clinician = TestHelper.createClinician();
        this.context.setClinician(this.clinician);
        this.till = (Party)this.create("party.organisationTill", Party.class);
        this.context.setTill((Entity)this.till);
        this.depositAccount = (Party)this.create("party.organisationDeposit", Party.class);
        this.context.setDeposit(this.depositAccount);
        this.user = (User)this.create("security.user", User.class);
        this.context.setUser(this.user);
        this.invoice = this.create("act.customerAccountChargesInvoice");
        this.context.addObject(this.invoice);
        this.visit = this.create("act.patientClinicalEvent");
        this.context.addObject(this.visit);
    }

    @Test
    public void testVariables() {
        MacroVariables variables = new MacroVariables(this.context, (ArchetypeService)this.getArchetypeService(), this.getLookupService());
        Assert.assertEquals((Object)this.practice, (Object)variables.get("practice"));
        Assert.assertEquals((Object)this.location, (Object)variables.get("location"));
        Assert.assertEquals((Object)this.stockLocation, (Object)variables.get("stockLocation"));
        Assert.assertEquals((Object)this.customer, (Object)variables.get("customer"));
        Assert.assertEquals((Object)this.patient, (Object)variables.get("patient"));
        Assert.assertEquals((Object)this.clinician, (Object)variables.get("clinician"));
        Assert.assertEquals((Object)this.till, (Object)variables.get("till"));
        Assert.assertEquals((Object)this.depositAccount, (Object)variables.get("depositAccount"));
        Assert.assertEquals((Object)this.user, (Object)variables.get("user"));
        Assert.assertEquals((Object)this.invoice, (Object)variables.get("invoice"));
        Assert.assertEquals((Object)this.visit, (Object)variables.get("visit"));
    }

    @Test
    public void testNodeResolution() {
        MacroVariables variables = new MacroVariables(this.context, (ArchetypeService)this.getArchetypeService(), this.getLookupService());
        Lookup species = TestHelper.getLookup((String)"lookup.species", (String)"CANINE");
        species.setName("Canine");
        this.save((IMObject)species);
        IMObjectBean bean = this.getBean((IMObject)this.patient);
        bean.setValue("name", (Object)"Fido");
        bean.setValue("species", (Object)"CANINE");
        Assert.assertEquals((Object)"Fido", (Object)variables.get("patient.name"));
        Assert.assertEquals((Object)"Canine", (Object)variables.get("patient.species"));
    }

    @Test
    public void testClinicianAndUserInstances() {
        MacroVariables variables = new MacroVariables(this.context, (ArchetypeService)this.getArchetypeService(), this.getLookupService());
        Object clinician = variables.get("clinician");
        Object user = variables.get("user");
        Assert.assertNotNull((Object)clinician);
        Assert.assertNotNull((Object)user);
        Assert.assertNotEquals((Object)clinician, (Object)user);
    }

    @Test
    public void testMissingVariable() {
        MacroVariables variables = new MacroVariables(this.context, (ArchetypeService)this.getArchetypeService(), this.getLookupService());
        Assert.assertNull((Object)variables.get("nosuchvariable"));
    }
}

