/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.job;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang3.RandomUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.business.service.security.AuthenticationContextImpl;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.job.AbstractJob;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.component.job.JobManager;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class JobManagerTestCase
extends AbstractAppTest {
    private final JobManager manager = new JobManager(500, "TestJob-%d"){};
    @Autowired
    private TestUserFactory userFactory;
    private User user;

    @Override
    @Before
    public void setUp() {
        super.setUp();
        this.user = (User)this.userFactory.newUser().build(false);
    }

    @Override
    @After
    public void tearDown() {
        this.manager.destroy();
    }

    @Test
    public void testRun() {
        TestJob job = new TestJob(this.newJob().build());
        Future future = this.manager.run(job);
        try {
            future.get();
        }
        catch (Throwable exception) {
            Assert.fail((String)("Job failed with " + exception.getMessage()));
        }
        job.waitForListener();
        job.checkCompleted(null);
    }

    @Test
    public void testRunGet() {
        Integer initial = RandomUtils.nextInt();
        AtomicReference completedValue = new AtomicReference();
        Job job = JobBuilder.newJob((String)"test", (User)this.user).get(() -> initial).completed(completedValue::set).build();
        TestJob testJob = new TestJob(job);
        Future future = this.manager.run(testJob);
        try {
            Assert.assertEquals((Object)initial, future.get());
        }
        catch (Throwable exception) {
            Assert.fail((String)("Job failed with " + exception.getMessage()));
        }
        testJob.waitForListener();
        testJob.checkCompleted(null);
    }

    @Test
    public void testRunFailure() {
        IllegalStateException expected = new IllegalStateException("Simulated failure");
        Job job = this.newJob().run(() -> {
            throw expected;
        }).failed(throwable -> {}).build();
        TestJob testJob = new TestJob(job);
        Future future = this.manager.run(testJob);
        try {
            future.get();
            Assert.fail((String)"Expected job to fail");
        }
        catch (Throwable exception) {
            Assert.assertTrue((boolean)(exception instanceof ExecutionException));
            Assert.assertEquals((Object)expected, (Object)exception.getCause());
        }
        testJob.waitForListener();
        testJob.checkFailure(expected, null);
    }

    @Test
    public void testCancelRun() {
        CountDownLatch latch1 = new CountDownLatch(1);
        CountDownLatch latch2 = new CountDownLatch(1);
        Job job = this.newJob().run(() -> {
            latch1.countDown();
            this.sleep(10000);
            try {
                latch2.await();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }).build();
        TestJob testJob = new TestJob(job);
        Future future = this.manager.run(testJob);
        try {
            latch1.await();
            future.cancel(true);
            latch2.countDown();
        }
        catch (Throwable exception) {
            Assert.fail((String)("Job failed with " + exception.getMessage()));
        }
        testJob.waitForListener();
        testJob.checkCancelled(null);
    }

    @Test
    public void testRunInteractive() {
        TestJob job = new TestJob(this.newJob().build());
        Future future = this.manager.runInteractive(job, "Cancel", "Cancel job");
        try {
            future.get();
        }
        catch (Throwable exception) {
            Assert.fail((String)("Job failed with " + exception.getMessage()));
        }
        this.sleep(1000);
        this.processQueuedTasks();
        job.waitForListener();
        job.checkCompleted(Thread.currentThread());
    }

    @Test
    public void testRunInteractiveGet() {
        Integer initial = RandomUtils.nextInt();
        AtomicReference completedValue = new AtomicReference();
        Job job = JobBuilder.newJob((String)"test", (User)this.user).get(() -> initial).completed(completedValue::set).build();
        TestJob testJob = new TestJob(job);
        Future future = this.manager.runInteractive(testJob, "Cancel", "Cancel job");
        try {
            Assert.assertEquals((Object)initial, future.get());
        }
        catch (Throwable exception) {
            Assert.fail((String)("Job failed with " + exception.getMessage()));
        }
        this.sleep(1000);
        this.processQueuedTasks();
        testJob.waitForListener();
        testJob.checkCompleted(Thread.currentThread());
    }

    @Test
    public void testRunInteractiveFailure() {
        IllegalStateException expected = new IllegalStateException("Simulated failure");
        Job job = this.newJob().run(() -> {
            throw expected;
        }).failed(throwable -> {}).build();
        TestJob testJob = new TestJob(job);
        Future future = this.manager.runInteractive(testJob, "Cancel", "Cancel job");
        try {
            future.get();
            Assert.fail((String)"Expected job to fail");
        }
        catch (Throwable exception) {
            Assert.assertTrue((boolean)(exception instanceof ExecutionException));
            Assert.assertEquals((Object)expected, (Object)exception.getCause());
        }
        this.sleep(1000);
        this.processQueuedTasks();
        testJob.waitForListener();
        testJob.checkFailure(expected, Thread.currentThread());
    }

    @Test
    public void testRunInteractiveCancel() {
        CountDownLatch latch = new CountDownLatch(1);
        Job job = this.newJob().run(() -> {
            latch.countDown();
            this.sleep(10000);
        }).build();
        TestJob testJob = new TestJob(job);
        Future future = this.manager.runInteractive(testJob, "Cancel", "Cancel job");
        try {
            latch.await();
            future.cancel(true);
        }
        catch (Throwable exception) {
            Assert.fail((String)("Job failed with " + exception.getMessage()));
        }
        this.sleep(1000);
        this.processQueuedTasks();
        testJob.waitForListener();
        testJob.checkCancelled(Thread.currentThread());
    }

    @Test
    public void testSecurityContextInherited() throws Exception {
        AuthenticationContextImpl context = new AuthenticationContextImpl();
        Thread parent = Thread.currentThread();
        context.setUser(this.user);
        Job job = JobBuilder.newJob((String)"test", (User)this.user).get(() -> {
            Assert.assertNotEquals((Object)parent, (Object)Thread.currentThread());
            return new AuthenticationContextImpl().getUser();
        }).build();
        Future future = this.manager.run(job);
        Assert.assertEquals((Object)this.user, future.get());
        context.setUser(null);
    }

    private <T> JobBuilder<T> newJob() {
        return JobBuilder.newJob((String)"test", (User)this.user);
    }

    private static class TestJob<T>
    extends AbstractJob<T> {
        private final Supplier<T> command;
        private final Consumer<T> completionListener;
        private final Runnable cancellationListener;
        private final Consumer<Throwable> failureListener;
        private final AtomicInteger runCounter = new AtomicInteger();
        private final AtomicInteger completionCounter = new AtomicInteger();
        private final AtomicReference<Thread> completionThread = new AtomicReference();
        private final AtomicInteger cancellationCounter = new AtomicInteger();
        private final AtomicReference<Thread> cancellationThread = new AtomicReference();
        private final AtomicInteger failureCounter = new AtomicInteger();
        private final AtomicReference<Throwable> caught = new AtomicReference();
        private final AtomicReference<Thread> failureThread = new AtomicReference();
        private final Semaphore semaphore = new Semaphore(0);

        public TestJob(Job<T> job) {
            super(job.getName(), job.getUser());
            this.command = job;
            this.completionListener = value -> this.runListener(this.completionCounter, this.completionThread, () -> {
                if (job.getCompletionListener() != null) {
                    job.getCompletionListener().accept(value);
                }
            });
            this.cancellationListener = () -> this.runListener(this.cancellationCounter, this.cancellationThread, () -> {
                if (job.getCancellationListener() != null) {
                    job.getCancellationListener().run();
                }
            });
            this.failureListener = throwable -> this.runListener(this.failureCounter, this.failureThread, () -> {
                this.caught.set((Throwable)throwable);
                if (job.getFailureListener() != null) {
                    job.getFailureListener().accept(throwable);
                }
            });
        }

        public Consumer<T> getCompletionListener() {
            return this.completionListener;
        }

        public Runnable getCancellationListener() {
            return this.cancellationListener;
        }

        public Consumer<Throwable> getFailureListener() {
            return this.failureListener;
        }

        public void waitForListener() {
            try {
                Assert.assertTrue((boolean)this.semaphore.tryAcquire(10L, TimeUnit.SECONDS));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        public void checkCompleted(Thread thread) {
            this.checkNoCancelDialog();
            Assert.assertEquals((long)1L, (long)this.runCounter.get());
            Assert.assertEquals((long)1L, (long)this.completionCounter.get());
            Assert.assertEquals((long)0L, (long)this.cancellationCounter.get());
            Assert.assertEquals((long)0L, (long)this.failureCounter.get());
            Assert.assertNull((Object)this.caught.get());
            if (thread != null) {
                Assert.assertEquals((Object)thread, (Object)this.completionThread.get());
            }
        }

        public void checkCancelled(Thread thread) {
            this.checkNoCancelDialog();
            Assert.assertEquals((long)1L, (long)this.runCounter.get());
            Assert.assertEquals((long)0L, (long)this.completionCounter.get());
            Assert.assertEquals((long)1L, (long)this.cancellationCounter.get());
            Assert.assertEquals((long)0L, (long)this.failureCounter.get());
            Assert.assertNull((Object)this.caught.get());
            if (thread != null) {
                Assert.assertEquals((Object)thread, (Object)this.cancellationThread.get());
            }
        }

        public void checkFailure(Throwable exception, Thread thread) {
            this.checkNoCancelDialog();
            Assert.assertEquals((long)1L, (long)this.runCounter.get());
            Assert.assertEquals((long)0L, (long)this.completionCounter.get());
            Assert.assertEquals((long)0L, (long)this.cancellationCounter.get());
            Assert.assertEquals((long)1L, (long)this.failureCounter.get());
            Assert.assertEquals((Object)exception, (Object)this.caught.get());
            if (thread != null) {
                Assert.assertEquals((Object)thread, (Object)this.failureThread.get());
            }
        }

        protected T runJob() {
            this.runCounter.incrementAndGet();
            return this.command.get();
        }

        private void checkNoCancelDialog() {
            Assert.assertNull((Object)EchoTestHelper.findWindowPane(JobManager.CancelDialog.class));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runListener(AtomicInteger counter, AtomicReference<Thread> thread, Runnable listener) {
            counter.incrementAndGet();
            thread.set(Thread.currentThread());
            try {
                listener.run();
            }
            finally {
                this.semaphore.release();
            }
        }
    }
}

