/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.relationship.EntityRelationshipEditor;
import org.openvpms.web.component.im.relationship.SingleEntityRelationshipCollectionEditor;
import org.openvpms.web.component.property.CollectionProperty;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;

public class SingleEntityRelationshipCollectionEditorTestCase
extends AbstractAppTest {
    @Test
    public void testOptionalRelationship() {
        Party location = TestHelper.createLocation();
        Party stockLocation = ProductTestHelper.createStockLocation();
        IMObjectBean bean = this.getBean((IMObject)location);
        Assert.assertNull((Object)bean.getObject("stockLocations"));
        CollectionProperty property = this.createCollectionProperty((IMObject)location, "stockLocations");
        DefaultLayoutContext layoutContext = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        SingleEntityRelationshipCollectionEditor editor = new SingleEntityRelationshipCollectionEditor(property, (Entity)location, (LayoutContext)layoutContext);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isEmpty());
        Assert.assertFalse((boolean)editor.isModified());
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertNull((Object)bean.getObject("stockLocations"));
        EntityRelationshipEditor stockLocationEditor = (EntityRelationshipEditor)editor.getCurrentEditor();
        stockLocationEditor.setTarget((IMObject)stockLocation);
        Assert.assertFalse((boolean)editor.isEmpty());
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertNotNull((Object)bean.getObject("stockLocations"));
        stockLocationEditor.setTarget(null);
        Assert.assertTrue((boolean)editor.isEmpty());
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertNull((Object)bean.getObject("stockLocations"));
    }

    private CollectionProperty createCollectionProperty(IMObject object, String name) {
        ArchetypeDescriptor archetype = DescriptorHelper.getArchetypeDescriptor((IMObject)object, (ArchetypeService)this.getArchetypeService());
        Assert.assertNotNull((Object)archetype);
        NodeDescriptor node = archetype.getNodeDescriptor(name);
        Assert.assertNotNull((Object)node);
        return new IMObjectProperty(object, (org.openvpms.component.model.archetype.NodeDescriptor)node);
    }
}

