/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.relationship;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.business.domain.im.common.EntityRelationship;
import org.openvpms.component.business.domain.im.common.SequencedPeriodRelationship;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.web.component.im.relationship.RelationshipState;
import org.openvpms.web.component.im.relationship.SequencedRelationshipCollectionHelper;

public class SequencedRelationshipCollectionHelperTest {
    @Test
    public void testSequence() {
        RelationshipState state1 = this.create(10);
        RelationshipState state2 = this.create(2);
        RelationshipState state3 = this.create(14);
        RelationshipState state4 = this.create(15);
        RelationshipState state5 = this.create(14);
        RelationshipState state6 = this.create(16);
        RelationshipState state7 = this.create(20);
        List<RelationshipState> states = Arrays.asList(state1, state2, state3, state4, state5, state6, state7);
        SequencedRelationshipCollectionHelper.sequenceStates(states);
        this.check(states, 10, 11, 14, 15, 16, 17, 20);
    }

    private void check(List<RelationshipState> states, int ... expected) {
        Assert.assertEquals((long)states.size(), (long)expected.length);
        for (int i = 0; i < states.size(); ++i) {
            SequencedPeriodRelationship relationship = (SequencedPeriodRelationship)states.get(i).getRelationship();
            Assert.assertEquals((long)expected[i], (long)relationship.getSequence());
        }
    }

    private RelationshipState create(int sequence) {
        EntityRelationship result = new EntityRelationship();
        result.setSequence(sequence);
        return new RelationshipState((Relationship)result, 0L, null, null, 0L, null, null, true);
    }
}

