/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.query;

import java.util.ArrayList;
import java.util.NoSuchElementException;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.web.component.im.query.ListResultSet;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;

public class ListResultSetIteratorTestCase {
    @Test
    public void testEmpty() {
        ArrayList objects = new ArrayList();
        ListResultSet set = new ListResultSet(objects, 10);
        ResultSetIterator iterator = new ResultSetIterator((ResultSet)set);
        Assert.assertFalse((boolean)iterator.hasNext());
        Assert.assertFalse((boolean)iterator.hasPrevious());
        try {
            iterator.next();
            Assert.fail((String)"Expected NoSuchElementException to be thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        try {
            iterator.previous();
            Assert.fail((String)"Expected NoSuchElementException to be thrown");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testIterationForCountEqualsPageSize() {
        this.checkIteration(10, 10);
    }

    @Test
    public void testIterationForCountLessThanPageSize() {
        this.checkIteration(7, 10);
    }

    @Test
    public void testIterationForCountGreaterThanPageSize() {
        this.checkIteration(20, 7);
    }

    @Test
    public void testPartialIteration() {
        ArrayList<Integer> objects = new ArrayList<Integer>();
        int count = 3;
        for (int i = 0; i < count; ++i) {
            objects.add(i);
        }
        ListResultSet set = new ListResultSet(objects, 20);
        ResultSetIterator iterator = new ResultSetIterator((ResultSet)set);
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)0L, (long)((Integer)iterator.next()).intValue());
        Assert.assertTrue((boolean)iterator.hasNext());
        Assert.assertEquals((long)1L, (long)((Integer)iterator.next()).intValue());
        Assert.assertTrue((boolean)iterator.hasPrevious());
        Assert.assertEquals((long)1L, (long)((Integer)iterator.previous()).intValue());
        Assert.assertTrue((boolean)iterator.hasPrevious());
        Assert.assertEquals((long)0L, (long)((Integer)iterator.previous()).intValue());
        Assert.assertFalse((boolean)iterator.hasPrevious());
    }

    private void checkIteration(int count, int pageSize) {
        ArrayList<Integer> objects = new ArrayList<Integer>();
        for (int i = 0; i < count; ++i) {
            objects.add(i);
        }
        ListResultSet set = new ListResultSet(objects, pageSize);
        ResultSetIterator iterator = new ResultSetIterator((ResultSet)set);
        int expected = -1;
        while (iterator.hasNext()) {
            Assert.assertEquals((long)(++expected), (long)iterator.nextIndex());
            Assert.assertEquals((long)expected, (long)((Integer)iterator.next()).intValue());
            Assert.assertEquals((long)expected, (long)iterator.lastIndex());
        }
        Assert.assertEquals((long)(count - 1), (long)expected);
        while (iterator.hasPrevious()) {
            Assert.assertEquals((long)expected, (long)iterator.previousIndex());
            Assert.assertEquals((long)expected, (long)((Integer)iterator.previous()).intValue());
            Assert.assertEquals((long)expected, (long)iterator.lastIndex());
            --expected;
        }
        Assert.assertEquals((long)-1L, (long)expected);
    }
}

