/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.product;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.archetype.rules.product.ProductPriceTestHelper;
import org.openvpms.archetype.rules.product.ProductRules;
import org.openvpms.archetype.rules.product.ProductSupplier;
import org.openvpms.archetype.rules.product.ProductTestHelper;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.lookup.TestMacroBuilder;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.product.TestMedicationProductBuilder;
import org.openvpms.archetype.test.builder.product.TestProductFactory;
import org.openvpms.archetype.test.builder.supplier.TestSupplierFactory;
import org.openvpms.archetype.test.builder.user.TestUserFactory;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.EntityLink;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.EditableIMObjectCollectionEditor;
import org.openvpms.web.component.im.edit.EditorTestHelper;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.SaveHelper;
import org.openvpms.web.component.im.layout.AbstractLayoutStrategy;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.product.MedicationLayoutStrategy;
import org.openvpms.web.component.im.product.ProductEditor;
import org.openvpms.web.component.im.product.ProductLayoutStrategy;
import org.openvpms.web.component.im.product.ProductPriceCollectionEditor;
import org.openvpms.web.component.im.product.ProductPriceEditor;
import org.openvpms.web.component.im.product.TemplateLayoutStrategy;
import org.openvpms.web.component.im.relationship.EntityLinkEditor;
import org.openvpms.web.component.im.table.IMTable;
import org.openvpms.web.component.im.view.IMObjectView;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.openvpms.web.test.EchoTestHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class ProductEditorTestCase
extends AbstractAppTest {
    @Autowired
    private ProductRules rules;
    @Autowired
    private TestLookupFactory lookupFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestProductFactory productFactory;
    @Autowired
    private TestSupplierFactory supplierFactory;
    @Autowired
    private TestUserFactory userFactory;

    @Override
    @Before
    public void setUp() {
        this.practiceFactory.getPractice();
        super.setUp();
    }

    @Test
    public void testUnitPriceCalculatedWhenAutoPriceUpdateTrue() {
        Product product = (Product)this.productFactory.newMedication().build(false);
        Party supplier = this.supplierFactory.createSupplier();
        Assert.assertTrue((boolean)product.getProductPrices().isEmpty());
        TestProductEditor editor = this.createEditor(product);
        ProductPriceCollectionEditor prices = editor.getPricesEditor();
        ProductPriceEditor priceEditor = (ProductPriceEditor)prices.add("productPrice.unitPrice");
        Assert.assertNotNull((Object)priceEditor);
        this.checkEquals(BigDecimal.ZERO, priceEditor.getCost());
        this.checkEquals(BigDecimal.valueOf(100L), priceEditor.getMarkup());
        this.checkEquals(BigDecimal.ZERO, priceEditor.getPrice());
        Assert.assertFalse((boolean)priceEditor.isValid());
        ProductPrice unit = priceEditor.getObject();
        Assert.assertNull((Object)unit.getPrice());
        Assert.assertTrue((boolean)product.getProductPrices().isEmpty());
        Date from = unit.getFromDate();
        BigDecimal listPrice = BigDecimal.ONE;
        BigDecimal newPrice = BigDecimal.valueOf(2L);
        this.addSupplier(editor, supplier, listPrice, true);
        Assert.assertTrue((boolean)priceEditor.isValid());
        this.checkEquals(listPrice, priceEditor.getCost());
        this.checkEquals(MathRules.ONE_HUNDRED, priceEditor.getMarkup());
        this.checkEquals(newPrice, priceEditor.getPrice());
        Assert.assertTrue((boolean)product.getProductPrices().contains(unit));
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        product = (Product)this.get((IMObject)product);
        Assert.assertEquals((long)1L, (long)product.getProductPrices().size());
        this.checkPrice(product, newPrice, listPrice, from, null, "Price created by auto-update of supplier: " + supplier.getName());
    }

    @Test
    public void testNewUnitPriceCalculatedWhenAutoPriceUpdateTrue() {
        Product product = (Product)this.productFactory.newMedication().build(false);
        Assert.assertTrue((boolean)product.getProductPrices().isEmpty());
        Date date1 = DateRules.getYesterday();
        ProductPrice unit1 = ProductPriceTestHelper.createUnitPrice((BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (Date)date1, null);
        product.addProductPrice(unit1);
        this.save((IMObject)product);
        TestProductEditor editor = this.createEditor(product);
        List prices1 = editor.getPrices();
        Assert.assertEquals((long)1L, (long)prices1.size());
        Party supplier = this.supplierFactory.createSupplier();
        BigDecimal listPrice = BigDecimal.valueOf(2L);
        EntityLinkEditor productSupplier = this.addSupplier(editor, supplier, listPrice, true);
        Assert.assertTrue((boolean)editor.isValid());
        List prices2 = editor.getPrices();
        Assert.assertEquals((long)2L, (long)prices2.size());
        Assert.assertEquals((Object)unit1, prices2.get(0));
        Assert.assertEquals((Object)date1, (Object)unit1.getFromDate());
        Date unit1ToDate = unit1.getToDate();
        Assert.assertNotNull((Object)unit1ToDate);
        Assert.assertTrue((unit1ToDate.compareTo(DateRules.getToday()) >= 0 ? 1 : 0) != 0);
        ProductPriceTestHelper.checkPrice((ProductPrice)unit1, (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (BigDecimal)MathRules.ONE_HUNDRED, (BigDecimal)MathRules.ONE_HUNDRED);
        ProductPrice unit2 = (ProductPrice)prices2.get(1);
        Assert.assertEquals((Object)unit2.getFromDate(), (Object)unit1ToDate);
        Assert.assertNull((Object)unit2.getToDate());
        ProductPriceTestHelper.checkPrice((ProductPrice)unit2, (BigDecimal)BigDecimal.valueOf(4L), (BigDecimal)listPrice, (BigDecimal)MathRules.ONE_HUNDRED, (BigDecimal)MathRules.ONE_HUNDRED, (Date)unit1ToDate, null);
        BigDecimal listPrice3 = BigDecimal.valueOf(3L);
        this.setListPrice(productSupplier, listPrice3);
        List prices3 = editor.getPrices();
        Assert.assertEquals((long)2L, (long)prices3.size());
        ProductPriceTestHelper.checkPrice((ProductPrice)((ProductPrice)prices3.get(0)), (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (BigDecimal)MathRules.ONE_HUNDRED, (BigDecimal)MathRules.ONE_HUNDRED, (Date)date1, (Date)unit1ToDate);
        ProductPriceTestHelper.checkPrice((ProductPrice)((ProductPrice)prices3.get(1)), (BigDecimal)BigDecimal.valueOf(6L), (BigDecimal)listPrice3, (BigDecimal)MathRules.ONE_HUNDRED, (BigDecimal)MathRules.ONE_HUNDRED, (Date)unit1ToDate, null);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        product = (Product)this.get((IMObject)product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, BigDecimal.ONE, BigDecimal.ZERO, date1, unit1ToDate, null);
        this.checkPrice(product, BigDecimal.valueOf(6L), listPrice3, unit1ToDate, null, "Price created by auto-update of supplier: " + supplier.getName());
    }

    @Test
    public void testUnitPriceNotCalculatedWhenAutoPriceUpdateFalse() {
        Product product = (Product)this.productFactory.newMedication().build(false);
        Assert.assertTrue((boolean)product.getProductPrices().isEmpty());
        Date date1 = DateRules.getYesterday();
        ProductPrice unit1 = ProductPriceTestHelper.createUnitPrice((BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (Date)date1, null);
        product.addProductPrice(unit1);
        this.save((IMObject)product);
        TestProductEditor editor = this.createEditor(product);
        List prices1 = editor.getPrices();
        Assert.assertEquals((long)1L, (long)prices1.size());
        Party supplier = this.supplierFactory.createSupplier();
        BigDecimal listPrice = BigDecimal.valueOf(2L);
        this.addSupplier(editor, supplier, listPrice, false);
        Assert.assertTrue((boolean)editor.isValid());
        List prices2 = editor.getPrices();
        Assert.assertEquals((long)1L, (long)prices2.size());
        ProductPriceTestHelper.checkPrice((ProductPrice)((ProductPrice)prices2.get(0)), (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (BigDecimal)MathRules.ONE_HUNDRED, (BigDecimal)MathRules.ONE_HUNDRED, (Date)date1, null);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        product = (Product)this.get((IMObject)product);
        Set prices = product.getProductPrices();
        Assert.assertEquals((long)1L, (long)prices.size());
        this.checkPrice(product, BigDecimal.ONE, BigDecimal.ZERO, date1, null, null);
    }

    @Test
    public void testAutoPriceUpdateOnlyOccursWhenCostPriceChanges() {
        Party supplier1 = this.supplierFactory.createSupplier();
        Party supplier2 = this.supplierFactory.createSupplier();
        Party supplier3 = this.supplierFactory.createSupplier();
        supplier3.setActive(false);
        this.save((IMObject)supplier3);
        Product product = (Product)this.productFactory.newMedication().build(false);
        Date date1 = DateRules.getYesterday();
        ProductPrice unit1 = ProductPriceTestHelper.createUnitPrice((BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (Date)date1, null);
        product.addProductPrice(unit1);
        ProductSupplier ps1 = this.rules.createProductSupplier(product, supplier1);
        ps1.setPackageSize(5);
        ps1.setListPrice(BigDecimal.valueOf(20L));
        ps1.setAutoPriceUpdate(true);
        ProductSupplier ps2 = this.rules.createProductSupplier(product, supplier2);
        ps2.setPackageSize(10);
        ps2.setListPrice(BigDecimal.valueOf(25L));
        ps2.setAutoPriceUpdate(false);
        ProductSupplier ps3 = this.rules.createProductSupplier(product, supplier3);
        ps3.setPackageSize(12);
        ps3.setListPrice(BigDecimal.valueOf(30L));
        ps3.setAutoPriceUpdate(false);
        this.save((IMObject)product);
        TestProductEditor editor = this.createEditor(product);
        List prices1 = editor.getPrices();
        Assert.assertEquals((long)1L, (long)prices1.size());
        this.checkPrice(product, BigDecimal.ONE, BigDecimal.ZERO, date1, null, null);
        EntityLinkEditor supplierEditor2 = this.getSupplierEditor(editor, supplier2);
        this.setAutoPriceUpdate(supplierEditor2, true);
        EntityLinkEditor supplierEditor3 = this.getSupplierEditor(editor, supplier3);
        this.setAutoPriceUpdate(supplierEditor3, true);
        List prices2 = editor.getPrices();
        Assert.assertEquals((long)2L, (long)prices2.size());
        Assert.assertEquals((Object)unit1, prices2.get(0));
        Assert.assertEquals((Object)date1, (Object)unit1.getFromDate());
        Date unit1ToDate = unit1.getToDate();
        Assert.assertNotNull((Object)unit1ToDate);
        Assert.assertTrue((unit1ToDate.compareTo(DateRules.getToday()) >= 0 ? 1 : 0) != 0);
        ProductPriceTestHelper.checkPrice((ProductPrice)unit1, (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (BigDecimal)MathRules.ONE_HUNDRED, (BigDecimal)MathRules.ONE_HUNDRED);
        ProductPrice unit2 = (ProductPrice)prices2.get(1);
        Assert.assertEquals((Object)unit2.getFromDate(), (Object)unit1ToDate);
        Assert.assertNull((Object)unit2.getToDate());
        ProductPriceTestHelper.checkPrice((ProductPrice)unit2, (BigDecimal)BigDecimal.valueOf(5L), (BigDecimal)new BigDecimal("2.5"), (BigDecimal)MathRules.ONE_HUNDRED, (BigDecimal)MathRules.ONE_HUNDRED, (Date)unit1ToDate, null);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        product = (Product)this.get((IMObject)product);
        Assert.assertEquals((long)2L, (long)product.getProductPrices().size());
        this.checkPrice(product, BigDecimal.ONE, BigDecimal.ZERO, date1, unit1ToDate, null);
        this.checkPrice(product, BigDecimal.valueOf(5L), new BigDecimal("2.5"), unit1ToDate, null, "Price created by auto-update of supplier: " + supplier2.getName());
    }

    @Test
    public void testDateRangeOverlap() {
        Product product = (Product)this.productFactory.newMedication().build(false);
        ProductPrice unit1 = ProductPriceTestHelper.createUnitPrice((String)"2016-01-01", null);
        ProductPrice unit2 = ProductPriceTestHelper.createUnitPrice((String)"2016-03-01", null);
        product.addProductPrice(unit1);
        product.addProductPrice(unit2);
        TestProductEditor editor = this.createEditor(product);
        Assert.assertFalse((boolean)editor.isValid());
        unit1.setToDate(unit2.getFromDate());
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testAdjustTimeOverlap() {
        Product product = (Product)this.productFactory.newMedication().build(false);
        ProductPrice unit1 = ProductPriceTestHelper.createUnitPrice((String)"2016-01-01", null);
        Date fromDate = TestHelper.getDatetime((String)"2016-03-25 10:00:00");
        ProductPrice unit2 = ProductPriceTestHelper.createUnitPrice((Date)fromDate, null);
        product.addProductPrice(unit1);
        product.addProductPrice(unit2);
        TestProductEditor editor = this.createEditor(product);
        Assert.assertFalse((boolean)editor.isValid());
        unit1.setToDate(TestHelper.getDatetime((String)"2016-03-25 10:05:00"));
        Assert.assertTrue((boolean)editor.isValid());
        Assert.assertEquals((Object)fromDate, (Object)unit1.getToDate());
    }

    @Test
    public void testMultiplePreferredSuppliers() {
        Party supplier = this.supplierFactory.createSupplier();
        Product product = this.productFactory.createMedication();
        ProductSupplier relationship1 = this.rules.createProductSupplier(product, supplier);
        ProductSupplier relationship2 = this.rules.createProductSupplier(product, supplier);
        relationship1.setPreferred(true);
        relationship2.setPreferred(true);
        this.save((IMObject)product);
        TestProductEditor editor1 = this.createEditor(product);
        Assert.assertFalse((boolean)editor1.isValid());
        relationship2.setPreferred(false);
        TestProductEditor editor2 = this.createEditor(product);
        Assert.assertTrue((boolean)editor2.isValid());
    }

    @Test
    public void testChangePreferredForInactiveSupplierRelationship() {
        Party supplier1 = this.supplierFactory.createSupplier();
        Party supplier2 = this.supplierFactory.createSupplier();
        Product product = this.productFactory.createMedication();
        ProductSupplier relationship1 = this.rules.createProductSupplier(product, supplier1);
        ProductSupplier relationship2 = this.rules.createProductSupplier(product, supplier2);
        relationship1.setPreferred(true);
        relationship2.setPreferred(false);
        this.save((IMObject)product);
        supplier1.setActive(false);
        this.save((IMObject)supplier1);
        TestProductEditor editor = this.createEditor(product);
        editor.getComponent();
        Assert.assertTrue((boolean)editor.isValid());
        EditableIMObjectCollectionEditor suppliers = editor.getSuppliersEditor();
        IMObjectEditor rel1editor = suppliers.getEditor((IMObject)relationship1.getRelationship());
        IMObjectEditor rel2editor = suppliers.getEditor((IMObject)relationship2.getRelationship());
        Assert.assertNotNull((Object)rel1editor);
        Assert.assertNotNull((Object)rel2editor);
        IMTable table = EchoTestHelper.findComponent(suppliers.getComponent(), IMTable.class);
        Assert.assertEquals((long)1L, (long)table.getObjects().size());
        table.setSelected(table.getObjects().get(0));
        table.processInput("action", null);
        Assert.assertTrue((boolean)rel1editor.getProperty("preferred").getBoolean());
        Assert.assertFalse((boolean)rel2editor.getProperty("preferred").getBoolean());
        rel2editor.getProperty("preferred").setValue((Object)true);
        Assert.assertFalse((boolean)rel1editor.getProperty("preferred").getBoolean());
        Assert.assertTrue((boolean)rel2editor.getProperty("preferred").getBoolean());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        product = (Product)this.get((IMObject)product);
        List ps1 = this.rules.getProductSuppliers(product, supplier1);
        Assert.assertEquals((long)1L, (long)ps1.size());
        Assert.assertFalse((boolean)((ProductSupplier)ps1.get(0)).isPreferred());
        List ps2 = this.rules.getProductSuppliers(product, supplier2);
        Assert.assertEquals((long)1L, (long)ps2.size());
        Assert.assertTrue((boolean)((ProductSupplier)ps2.get(0)).isPreferred());
    }

    @Test
    public void testStockLocationSupplierDependentOnSuppliers() {
        Party supplier1 = this.supplierFactory.createSupplier();
        Party stockLocation = this.practiceFactory.createStockLocation(new Party[0]);
        Product product = (Product)((TestMedicationProductBuilder)this.productFactory.newMedication().newProductStockLocation().supplier(supplier1).stockLocation(stockLocation).add()).build();
        TestProductEditor editor = this.createEditor(product);
        String message = stockLocation.getName() + " specifies " + supplier1.getName() + " as the preferred supplier, but " + supplier1.getName() + " is not a supplier of " + product.getName();
        EditorTestHelper.assertInvalid((Modifiable)editor, message);
        EditableIMObjectCollectionEditor suppliers = editor.getSuppliersEditor();
        ProductSupplier relationship1 = this.rules.createProductSupplier(product, supplier1);
        suppliers.add((IMObject)relationship1.getRelationship());
        EditorTestHelper.assertValid((Modifiable)editor);
        suppliers.remove((IMObject)relationship1.getRelationship());
        EditorTestHelper.assertInvalid((Modifiable)editor, message);
    }

    @Test
    public void testLayoutStrategy() {
        this.checkLayoutStrategy(this.productFactory.createMedication(), MedicationLayoutStrategy.class);
        this.checkLayoutStrategy(this.productFactory.createMerchandise(), ProductLayoutStrategy.class);
        this.checkLayoutStrategy(this.productFactory.createService(), ProductLayoutStrategy.class);
        this.checkLayoutStrategy(this.productFactory.createTemplate(), TemplateLayoutStrategy.class);
        this.checkLayoutStrategy(ProductTestHelper.createPriceTemplate(), ProductLayoutStrategy.class);
    }

    @Test
    public void testDeletionPriceWithFromDateLessThanTodayDeletion() {
        User user = this.userFactory.createUser();
        User admin = this.userFactory.createAdministrator();
        Product product1 = (Product)this.productFactory.newMedication().build(false);
        ProductPrice price1 = ProductPriceTestHelper.createUnitPrice((Date)DateRules.getToday(), null);
        ProductPrice price2 = ProductPriceTestHelper.createUnitPrice((Date)DateRules.getTomorrow(), null);
        ProductPrice price3 = ProductPriceTestHelper.createUnitPrice((Date)DateRules.getYesterday(), null);
        ProductPrice price4 = ProductPriceTestHelper.createUnitPrice((Date)null, null);
        product1.addProductPrice(price1);
        product1.addProductPrice(price2);
        product1.addProductPrice(price3);
        product1.addProductPrice(price4);
        TestProductEditor editor1 = this.createEditor(product1, user);
        this.checkDeleteEnabled(editor1, price1, true);
        this.checkDeleteEnabled(editor1, price2, true);
        this.checkDeleteEnabled(editor1, price3, true);
        this.checkDeleteEnabled(editor1, price4, true);
        TestProductEditor editor2 = this.createEditor(product1, admin);
        this.checkDeleteEnabled(editor2, price1, true);
        this.checkDeleteEnabled(editor2, price2, true);
        this.checkDeleteEnabled(editor2, price3, true);
        this.checkDeleteEnabled(editor2, price4, true);
        this.save((IMObject)product1);
        TestProductEditor editor3 = this.createEditor(product1, user);
        this.checkDeleteEnabled(editor3, price1, true);
        this.checkDeleteEnabled(editor3, price2, true);
        this.checkDeleteEnabled(editor3, price3, false);
        this.checkDeleteEnabled(editor3, price4, false);
        TestProductEditor editor4 = this.createEditor(product1, admin);
        this.checkDeleteEnabled(editor4, price1, true);
        this.checkDeleteEnabled(editor4, price2, true);
        this.checkDeleteEnabled(editor4, price3, true);
        this.checkDeleteEnabled(editor4, price4, true);
        Product product2 = (Product)this.productFactory.newMedication().build(false);
        ProductPrice price5 = ProductPriceTestHelper.createUnitPrice((Date)DateRules.getYesterday(), null);
        product2.addProductPrice(price5);
        TestProductEditor editor5 = this.createEditor(product2, user);
        this.checkDeleteEnabled(editor5, price5, true);
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor5));
        this.checkDeleteEnabled(editor5, price5, true);
    }

    @Test
    public void testMacroNotExpandedInDispensingInstructions() {
        Product product = (Product)this.productFactory.newMedication().build(false);
        TestProductEditor editor = this.createEditor(product);
        Lookup macro = (Lookup)((TestMacroBuilder)this.lookupFactory.newMacro().uniqueCode("@test")).expression("'test macro'").build();
        editor.getProperty("dispInstructions").setValue((Object)macro.getCode());
        editor.getProperty("usageNotes").setValue((Object)macro.getCode());
        Assert.assertTrue((boolean)SaveHelper.save((IMObjectEditor)editor));
        product = (Product)this.get((IMObject)product);
        IMObjectBean bean = this.getBean((IMObject)product);
        Assert.assertEquals((Object)macro.getCode(), (Object)bean.getString("dispInstructions"));
        Assert.assertEquals((Object)"test macro", (Object)bean.getString("usageNotes"));
    }

    protected TestProductEditor createEditor(Product product) {
        return this.createEditor(product, null);
    }

    protected TestProductEditor createEditor(Product product, User user) {
        LocalContext local = new LocalContext();
        local.setUser(user);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)local, new HelpContext("foo", null));
        TestProductEditor editor = new TestProductEditor(product, null, (LayoutContext)context);
        editor.getComponent();
        return editor;
    }

    private void checkDeleteEnabled(TestProductEditor editor, ProductPrice price, boolean enabled) {
        ProductPriceCollectionEditor prices = editor.getPricesEditor();
        prices.selectAndEdit((IMObject)price);
        Assert.assertNotNull((Object)prices.getCurrentEditor());
        Assert.assertEquals((Object)price, (Object)prices.getCurrentEditor().getObject());
        Assert.assertEquals((Object)enabled, (Object)prices.getButtons().isEnabled("delete"));
    }

    private void checkPrice(Product product, BigDecimal price, BigDecimal cost, Date from, Date to, String notes) {
        ProductPrice productPrice = ProductPriceTestHelper.checkPrice((Collection)product.getProductPrices(), (BigDecimal)price, (BigDecimal)cost, (BigDecimal)MathRules.ONE_HUNDRED, (BigDecimal)MathRules.ONE_HUNDRED, (Date)from, (Date)to, null);
        IMObjectBean bean = this.getBean((IMObject)productPrice);
        Assert.assertEquals((Object)notes, (Object)bean.getString("notes"));
    }

    private void checkLayoutStrategy(Product product, Class<? extends AbstractLayoutStrategy> expected) {
        TestProductEditor editor = this.createEditor(product);
        Assert.assertNotNull((Object)editor.getView().getLayout());
        Assert.assertEquals(expected, editor.getView().getLayout().getClass());
    }

    private EntityLinkEditor addSupplier(ProductEditor editor, Party supplier, BigDecimal listPrice, boolean autoPriceUpdate) {
        EditableIMObjectCollectionEditor suppliers = editor.getSuppliersEditor();
        EntityLinkEditor relationshipEditor = (EntityLinkEditor)suppliers.getFirstEditor(true);
        Assert.assertNotNull((Object)relationshipEditor);
        relationshipEditor.getComponent();
        relationshipEditor.setTarget((IMObject)supplier);
        this.setPackageSize(relationshipEditor, BigDecimal.ONE);
        this.setListPrice(relationshipEditor, listPrice);
        this.setAutoPriceUpdate(relationshipEditor, autoPriceUpdate);
        return relationshipEditor;
    }

    private EntityLinkEditor getSupplierEditor(ProductEditor editor, Party supplier) {
        EntityLinkEditor relationshipEditor = null;
        EditableIMObjectCollectionEditor suppliers = editor.getSuppliersEditor();
        for (IMObject object : suppliers.getCurrentObjects()) {
            EntityLink link = (EntityLink)object;
            if (!Objects.equals(supplier.getObjectReference(), link.getTarget())) continue;
            relationshipEditor = (EntityLinkEditor)suppliers.getEditor(object);
            break;
        }
        Assert.assertNotNull(relationshipEditor);
        return relationshipEditor;
    }

    private void setAutoPriceUpdate(EntityLinkEditor relationshipEditor, boolean autoPriceUpdate) {
        relationshipEditor.getProperty("autoPriceUpdate").setValue((Object)autoPriceUpdate);
    }

    private void setPackageSize(EntityLinkEditor relationshipEditor, BigDecimal size) {
        relationshipEditor.getProperty("packageSize").setValue((Object)size);
    }

    private void setListPrice(EntityLinkEditor editor, BigDecimal listPrice) {
        editor.getProperty("listPrice").setValue((Object)listPrice);
    }

    private static class TestProductEditor
    extends ProductEditor {
        public TestProductEditor(Product object, IMObject parent, LayoutContext layoutContext) {
            super(object, parent, layoutContext);
        }

        public IMObjectView getView() {
            return super.getView();
        }
    }
}

