/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import com.mysql.cj.jdbc.exceptions.MySQLTransactionRollbackException;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.sql.SQLException;
import java.util.ArrayList;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.StaleStateException;
import org.hibernate.exception.LockAcquisitionException;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.practice.TestPracticeFactory;
import org.openvpms.archetype.test.builder.scheduling.TestAppointmentBuilder;
import org.openvpms.archetype.test.builder.scheduling.TestSchedulingFactory;
import org.openvpms.archetype.test.builder.scheduling.TestTaskBuilder;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.DefaultIMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorOperation;
import org.openvpms.web.component.im.edit.IMObjectEditorSaver;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.CannotAcquireLockException;
import org.springframework.orm.hibernate5.HibernateOptimisticLockingFailureException;

public class IMObjectEditorSaverTestCase
extends AbstractAppTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestPracticeFactory practiceFactory;
    @Autowired
    private TestSchedulingFactory schedulingFactory;

    @Test
    public void testErrorMessageWhenExceptionThrownForNonReloadingEditor() {
        this.checkErrorMessageForExceptionDuringSave(new IllegalStateException("Save error"), false, "Save error");
        this.checkErrorMessageForExceptionDuringSave((RuntimeException)new ObjectNotFoundException((Serializable)((Object)"foo"), "bar"), false, "[bar#foo] may have been deleted by another user");
    }

    @Test
    public void testErrorMessageWhenExceptionThrownForReloadingEditor() {
        this.checkErrorMessageForExceptionDuringSave(new IllegalStateException("Save error"), true, "Save error.\n\nYour changes have been reverted.");
        this.checkErrorMessageForExceptionDuringSave((RuntimeException)new ObjectNotFoundException((Serializable)((Object)"foo"), "bar"), true, "The Appointment could not be saved. It may have been changed by another user.\n\nYour changes have been reverted.");
    }

    @Test
    public void testErrorMessageWhenRuleThrowsValidationExceptionThrownForNonReloadingEditor() {
        this.checkErrorMessageForRuleValidationException(false, "Failed to validate Customer of Task: must supply at least 1 item");
    }

    @Test
    public void testErrorMessageWhenRuleThrowsValidationExceptionThrownForReloadingEditor() {
        String error = "Failed to validate Customer of Task: must supply at least 1 item.\n\nYour changes have been reverted.";
        this.checkErrorMessageForRuleValidationException(true, error);
    }

    @Test
    public void testErrorMessageForDeadlock() {
        CannotAcquireLockException exception = new CannotAcquireLockException("could not execute batch", (Throwable)new LockAcquisitionException("could not execute batch", (SQLException)new BatchUpdateException((Throwable)new MySQLTransactionRollbackException("Deadlock found when trying to get lock; try restarting transaction"))));
        this.checkErrorMessageForExceptionDuringSave((RuntimeException)exception, true, "The Appointment could not be saved due to a deadlock. Please retry the operation.\n\nYour changes have been reverted.");
        this.checkErrorMessageForExceptionDuringSave((RuntimeException)exception, false, "The Appointment could not be saved due to a deadlock. Please retry the operation.");
    }

    @Test
    public void testErrorMessageForStaleStateException() {
        HibernateOptimisticLockingFailureException exception = new HibernateOptimisticLockingFailureException(new StaleStateException("Batch update returned unexpected row count from update [0]; actual row count: 0; expected: 1"));
        this.checkErrorMessageForExceptionDuringSave((RuntimeException)exception, true, "The Appointment could not be saved. It may have been changed by another user.\n\nYour changes have been reverted.");
    }

    private void checkErrorMessageForExceptionDuringSave(final RuntimeException exception, final boolean reload, String error) {
        ArrayList<String> errors = new ArrayList<String>();
        this.initErrorHandler(errors);
        Act appointment = this.createAppointment();
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        DefaultIMObjectEditor editor = new DefaultIMObjectEditor((IMObject)appointment, (LayoutContext)context){

            public void save() {
                throw exception;
            }
        };
        IMObjectEditorSaver.SaveOperation strategy = new IMObjectEditorSaver.SaveOperation(){

            protected boolean reload(IMObjectEditor editor) {
                return reload;
            }
        };
        IMObjectEditorSaver saver = new IMObjectEditorSaver((IMObjectEditorOperation)strategy);
        saver.save((IMObjectEditor)editor);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)error, errors.get(0));
    }

    private Act createAppointment() {
        return (Act)this.newAppointment().build();
    }

    private TestAppointmentBuilder newAppointment() {
        Party location = this.practiceFactory.createLocation();
        return (TestAppointmentBuilder)((TestAppointmentBuilder)this.schedulingFactory.newAppointment().startTime(DateRules.getToday())).schedule(this.schedulingFactory.createSchedule(location)).appointmentType(this.schedulingFactory.createAppointmentType()).customer(this.customerFactory.createCustomer());
    }

    private void checkErrorMessageForRuleValidationException(final boolean reload, String error) {
        ArrayList<String> errors = new ArrayList<String>();
        this.initErrorHandler(errors);
        TestAppointmentBuilder builder = this.newAppointment();
        Act task = (Act)((TestTaskBuilder)((TestTaskBuilder)((TestTaskBuilder)this.schedulingFactory.newTask().startTime(DateRules.getTomorrow())).taskType(this.schedulingFactory.createTaskType()).customer(builder.getCustomer())).patient(builder.getPatient())).workList(this.schedulingFactory.createWorkList()).build();
        Act appointment = (Act)builder.task(task).build();
        IMObjectBean taskBean = this.getBean((IMObject)task);
        taskBean.removeValues("customer");
        this.getArchetypeService().save((IMObject)task, false);
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        DefaultIMObjectEditor editor = new DefaultIMObjectEditor((IMObject)appointment, (LayoutContext)context);
        editor.getProperty("status").setValue((Object)"COMPLETED");
        IMObjectEditorSaver.SaveOperation strategy = new IMObjectEditorSaver.SaveOperation(){

            public boolean reload(IMObjectEditor editor) {
                return reload;
            }
        };
        IMObjectEditorSaver saver = new IMObjectEditorSaver((IMObjectEditorOperation)strategy);
        saver.save((IMObjectEditor)editor);
        Assert.assertEquals((long)1L, (long)errors.size());
        Assert.assertEquals((Object)error, errors.get(0));
    }
}

