/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.edit;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.edit.DefaultIMObjectReferenceEditor;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.ListQuery;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.select.AbstractQuerySelector;
import org.openvpms.web.component.im.select.IMObjectSelector;
import org.openvpms.web.component.property.IMObjectProperty;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.test.AbstractAppTest;

public class DefaultIMObjectReferenceEditorTestCase
extends AbstractAppTest {
    private Property property;
    private IMObject parent;
    private int modifiedCount;

    @Override
    @Before
    public void setUp() {
        this.parent = this.create("entityRelationship.patientOwner");
        this.property = new IMObjectProperty(this.parent, this.getBean(this.parent).getNode("target"));
        this.property.addModifiableListener(modifiable -> ++this.modifiedCount);
        super.setUp();
    }

    @Test
    public void testSetTextForOneMatch() {
        TestReferenceEditor editor = this.createEditor();
        Party patient = this.createPatient("Fido");
        editor.setQueryObjects(patient);
        TextField textField = editor.getSelector().getTextField();
        Assert.assertTrue((boolean)editor.isNull());
        Assert.assertFalse((boolean)editor.isModified());
        Assert.assertEquals((long)0L, (long)editor.getOnUpdated());
        Assert.assertNull((Object)this.property.getReference());
        Assert.assertEquals((long)0L, (long)editor.getOnUpdated());
        Assert.assertEquals((long)0L, (long)this.modifiedCount);
        Assert.assertFalse((boolean)editor.isValid());
        textField.setText("Fi");
        Assert.assertEquals((Object)"Fido", (Object)textField.getText());
        Assert.assertFalse((boolean)editor.isNull());
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertEquals((Object)patient.getObjectReference(), (Object)this.property.getReference());
        Assert.assertEquals((long)1L, (long)this.modifiedCount);
        Assert.assertTrue((boolean)editor.isValid());
        textField.setText(null);
        Assert.assertTrue((boolean)editor.isNull());
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertNull((Object)this.property.getReference());
        Assert.assertEquals((long)2L, (long)this.modifiedCount);
        Assert.assertFalse((boolean)editor.isValid());
    }

    @Test
    public void testSetTextForTwoMatches() {
        TestReferenceEditor editor = this.createEditor();
        Party patient1 = this.createPatient("Fido");
        Party patient2 = this.createPatient("Fifi");
        editor.setQueryObjects(patient1, patient2);
        editor.setSelection(patient2);
        TextField textField = editor.getSelector().getTextField();
        textField.setText("Fi");
        Assert.assertEquals((Object)"Fifi", (Object)textField.getText());
        Assert.assertFalse((boolean)editor.isNull());
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertEquals((Object)patient2.getObjectReference(), (Object)this.property.getReference());
        Assert.assertEquals((long)1L, (long)editor.getOnUpdated());
        Assert.assertEquals((long)1L, (long)this.modifiedCount);
        Assert.assertTrue((boolean)editor.isValid());
        editor.setSelection(patient1);
        textField.setText("Fi");
        Assert.assertEquals((Object)"Fido", (Object)textField.getText());
        Assert.assertFalse((boolean)editor.isNull());
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertEquals((Object)patient1.getObjectReference(), (Object)this.property.getReference());
        Assert.assertEquals((long)2L, (long)editor.getOnUpdated());
        Assert.assertEquals((long)2L, (long)this.modifiedCount);
        Assert.assertTrue((boolean)editor.isValid());
    }

    @Test
    public void testUpdatePropertyFromWithinCallback() {
        TestReferenceEditor editor = this.createEditor();
        Party patient1 = this.createPatient("Fido");
        Party patient2 = this.createPatient("Fifi");
        editor.setQueryObjects(patient1, patient2);
        TextField textField = editor.getSelector().getTextField();
        this.property.addModifiableListener(modifiable -> this.property.setValue((Object)patient2.getObjectReference()));
        textField.setText("Fido");
        Assert.assertEquals((Object)"Fifi", (Object)textField.getText());
        Assert.assertFalse((boolean)editor.isNull());
        Assert.assertTrue((boolean)editor.isModified());
        Assert.assertEquals((Object)patient2.getObjectReference(), (Object)this.property.getReference());
        Assert.assertEquals((long)2L, (long)editor.getOnUpdated());
        Assert.assertEquals((long)2L, (long)this.modifiedCount);
        Assert.assertTrue((boolean)editor.isValid());
    }

    private Party createPatient(String name) {
        Party patient = TestHelper.createPatient((boolean)false);
        patient.setName(name);
        this.save((IMObject)patient);
        return patient;
    }

    private TestReferenceEditor createEditor() {
        DefaultLayoutContext context = new DefaultLayoutContext((Context)new LocalContext(), new HelpContext("foo", null));
        TestReferenceEditor editor = new TestReferenceEditor(this.property, this.parent, (LayoutContext)context);
        editor.getComponent();
        return editor;
    }

    private static class TestReferenceEditor
    extends DefaultIMObjectReferenceEditor<Party> {
        private List<Party> queryObjects = new ArrayList<Party>();
        private Party selection;
        private int onUpdated;

        public TestReferenceEditor(Property property, IMObject parent, LayoutContext context) {
            super(property, parent, context);
        }

        public void setQueryObjects(Party ... objects) {
            this.queryObjects = Arrays.asList(objects);
        }

        public void setSelection(Party selection) {
            this.selection = selection;
        }

        public int getOnUpdated() {
            return this.onUpdated;
        }

        public AbstractQuerySelector<Party> getSelector() {
            return super.getSelector();
        }

        protected IMObjectSelector<Party> createSelector(Property property, LayoutContext context, boolean allowCreate) {
            return new IMObjectSelector<Party>(property, allowCreate, context){

                protected Query<Party> createQuery(String name) {
                    return this.createQuery(name);
                }

                protected Browser<Party> createBrowser(Query<Party> query) {
                    return this.createBrowser(query);
                }

                protected void onSelect(boolean runQuery) {
                    Assert.assertNotNull((String)"selection cannot be null", (Object)selection);
                    Browser browser = this.createBrowser(this.getText(), runQuery);
                    this.onSelected(selection, browser);
                }
            };
        }

        protected Query<Party> createQuery(String name) {
            ArrayList<Party> objects = new ArrayList<Party>();
            if (name == null) {
                objects.addAll(this.queryObjects);
            } else {
                for (Party object : this.queryObjects) {
                    if (!object.getName().startsWith(name)) continue;
                    objects.add(object);
                }
            }
            return new ListQuery(objects, "party.patientpet", Party.class);
        }

        protected void onUpdated(Party object) {
            ++this.onUpdated;
        }
    }
}

