/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.doc;

import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.doc.DocumentActEditDialog;
import org.openvpms.web.component.im.doc.DocumentActEditor;
import org.openvpms.web.component.im.doc.VersionedDocumentActEditorTest;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class TemplatedVersionedDocumentActEditorTest<T extends DocumentActEditor>
extends VersionedDocumentActEditorTest<T> {
    @Autowired
    private EditDialogFactory dialogFactory;

    public TemplatedVersionedDocumentActEditorTest(Class<T> type, String archetype) {
        super(type, archetype);
    }

    @Test
    public void testDocGenerationFromTemplate() {
        DocumentAct act = this.createAct();
        Entity template = this.createDocumentTemplate(act.getArchetype());
        DocumentActEditor editor = this.createEditor(act);
        editor.getComponent();
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        editor.setTemplate(template);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.NEEDS_UPDATE, (Object)editor.getDocumentStatus());
        editor.generateDocument(success -> {
            Assert.assertNotNull((Object)success);
            Assert.assertTrue((boolean)success);
        });
        this.processQueuedTasks(10, () -> act.getDocument() != null);
        Reference docRef = act.getDocument();
        Assert.assertNotNull((Object)docRef);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Assert.assertTrue((boolean)this.save(editor));
        Document doc = (Document)this.get(docRef);
        Assert.assertNotNull((Object)doc);
        Assert.assertEquals((Object)"application/pdf", (Object)doc.getMimeType());
        Assert.assertEquals((Object)"blank.pdf", (Object)doc.getName());
        this.delete(editor);
        Assert.assertNull((Object)this.get((IMObject)act));
        Assert.assertNull((Object)this.get(docRef));
    }

    @Test
    public void testGenerationWithVersioning() {
        DocumentAct act = this.createAct();
        Entity template1 = this.createDocumentTemplate(act.getArchetype());
        Entity template2 = this.createDocumentTemplate(act.getArchetype());
        DocumentActEditor editor = this.createEditor(act);
        editor.getComponent();
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        editor.setTemplate(template1);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.NEEDS_UPDATE, (Object)editor.getDocumentStatus());
        editor.generateDocument(success -> {
            Assert.assertNotNull((Object)success);
            Assert.assertTrue((boolean)success);
        });
        this.processQueuedTasks(10, () -> act.getDocument() != null);
        Reference docRef1 = act.getDocument();
        Assert.assertNotNull((Object)docRef1);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Assert.assertTrue((boolean)this.save(editor));
        editor.setTemplate(template2);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.NEEDS_UPDATE, (Object)editor.getDocumentStatus());
        editor.generateDocument(success -> {
            Assert.assertNotNull((Object)success);
            Assert.assertTrue((boolean)success);
        });
        this.processQueuedTasks(10, () -> !Objects.equals(act.getDocument(), docRef1));
        Reference docRef2 = act.getDocument();
        Assert.assertNotNull((Object)docRef2);
        Assert.assertEquals((Object)DocumentActEditor.DocumentStatus.UP_TO_DATE, (Object)editor.getDocumentStatus());
        Assert.assertTrue((boolean)this.save(editor));
        List<DocumentAct> versions = this.getVersions(act);
        Assert.assertEquals((long)1L, (long)versions.size());
        DocumentAct version1 = this.checkVersion(versions, 0, docRef1);
        this.delete(editor);
        Assert.assertNull((Object)this.get((IMObject)act));
        Assert.assertNull((Object)this.get((IMObject)version1));
        Assert.assertNull((Object)this.get(docRef1));
        Assert.assertNull((Object)this.get(docRef2));
    }

    @Test
    public void testEditDialogFactory() {
        DocumentAct act = this.createAct();
        EditDialog dialog = this.dialogFactory.create((IMObjectEditor)this.createEditor(act), (Context)new LocalContext());
        Assert.assertTrue((boolean)(dialog instanceof DocumentActEditDialog));
    }

    protected List<DocumentAct> getVersions(DocumentAct act) {
        IMObjectBean bean = this.getBean((IMObject)act);
        List versions = bean.getTargets("versions", DocumentAct.class);
        versions.sort(Comparator.comparingLong(IMObject::getId));
        return versions;
    }

    protected DocumentAct checkVersion(List<DocumentAct> versions, int index, Reference docRef) {
        Assert.assertTrue((index < versions.size() ? 1 : 0) != 0);
        DocumentAct version = versions.get(index);
        Assert.assertEquals((Object)docRef, (Object)version.getDocument());
        Assert.assertNotNull((Object)this.get(docRef));
        return version;
    }
}

