/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.delete;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.LocalContext;
import org.openvpms.web.component.im.delete.ActDeletionHandler;
import org.openvpms.web.component.im.delete.Deletable;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.edit.IMObjectEditorFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;
import org.openvpms.web.test.AbstractAppTest;
import org.springframework.beans.factory.annotation.Autowired;

public class ActDeletionHandlerTestCase
extends AbstractAppTest {
    @Autowired
    private IMObjectEditorFactory factory;

    @Test
    public void testDelete() {
        Party customer = TestHelper.createCustomer();
        Product product = TestHelper.createProduct();
        List charge1 = FinancialTestHelper.createChargesCounter((BigDecimal)BigDecimal.TEN, (Party)customer, (Product)product, (String)"IN_PROGRESS");
        List charge2 = FinancialTestHelper.createChargesCounter((BigDecimal)BigDecimal.TEN, (Party)customer, (Product)product, (String)"POSTED");
        this.save(charge1);
        this.save(charge2);
        ActDeletionHandler<Act> handler1 = this.createDeletionHandler((Act)charge1.get(0));
        Assert.assertTrue((boolean)handler1.getDeletable().canDelete());
        handler1.delete((Context)new LocalContext(), new HelpContext("foo", null));
        Assert.assertNull((Object)this.get((IMObject)charge1.get(0)));
        Assert.assertNull((Object)this.get((IMObject)charge1.get(1)));
        ActDeletionHandler<Act> handler2 = this.createDeletionHandler((Act)charge2.get(0));
        Deletable deletable = handler2.getDeletable();
        Assert.assertFalse((boolean)deletable.canDelete());
        Assert.assertEquals((Object)"Cannot delete Counter Sale. It has been finalised.", (Object)deletable.getReason());
        try {
            handler2.delete((Context)new LocalContext(), new HelpContext("foo", null));
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.get((IMObject)charge2.get(0)));
        Assert.assertNotNull((Object)this.get((IMObject)charge2.get(1)));
    }

    @Test
    public void testDeactivate() {
        Party customer = TestHelper.createCustomer();
        Product product = TestHelper.createProduct();
        List charge1 = FinancialTestHelper.createChargesCounter((BigDecimal)BigDecimal.TEN, (Party)customer, (Product)product, (String)"IN_PROGRESS");
        List charge2 = FinancialTestHelper.createChargesCounter((BigDecimal)BigDecimal.TEN, (Party)customer, (Product)product, (String)"POSTED");
        this.save(charge1);
        this.save(charge2);
        ActDeletionHandler<Act> handler1 = this.createDeletionHandler((Act)charge1.get(0));
        Assert.assertFalse((boolean)handler1.canDeactivate());
        try {
            handler1.deactivate();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        ActDeletionHandler<Act> handler2 = this.createDeletionHandler((Act)charge2.get(0));
        Assert.assertFalse((boolean)handler2.canDeactivate());
        try {
            handler2.deactivate();
            Assert.fail((String)"Expected IllegalStateException");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    @Test
    public void testFactory() {
        IMObjectDeletionHandlerFactory factory = new IMObjectDeletionHandlerFactory(this.getArchetypeService());
        Assert.assertNotNull((Object)this.applicationContext);
        factory.setApplicationContext(this.applicationContext);
        Party patient = TestHelper.createPatient();
        Act act = PatientTestHelper.createNote((Date)new Date(), (Party)patient);
        DocumentAct documentAct = PatientTestHelper.createDocumentForm((Party)patient);
        List charge = FinancialTestHelper.createChargesCounter((BigDecimal)BigDecimal.TEN, (Party)TestHelper.createCustomer(), (Product)TestHelper.createProduct(), (String)"IN_PROGRESS");
        this.save(charge);
        Assert.assertTrue((boolean)(factory.create((IMObject)act) instanceof ActDeletionHandler));
        Assert.assertTrue((boolean)(factory.create((IMObject)documentAct) instanceof ActDeletionHandler));
        Assert.assertTrue((boolean)(factory.create((IMObject)charge.get(0)) instanceof ActDeletionHandler));
    }

    protected <T extends Act> ActDeletionHandler<T> createDeletionHandler(T act) {
        return new ActDeletionHandler(act, this.factory, ServiceHelper.getTransactionManager(), ServiceHelper.getArchetypeService());
    }
}

