/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.contact;

import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.party.CustomerRules;
import org.openvpms.archetype.rules.party.PartyRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.builder.party.TestPhoneContactBuilder;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.springframework.beans.factory.annotation.Autowired;

public class ContactHelperTestCase
extends ArchetypeServiceTest {
    @Autowired
    private CustomerRules rules;

    @Test
    public void testAbbreviatePhone() {
        Contact contact1 = ((TestPhoneContactBuilder)new TestPhoneContactBuilder((ArchetypeService)this.getArchetypeService()).name("Joanne Smith")).areaCode("03").phone("9444 5555").build();
        Contact contact2 = ((TestPhoneContactBuilder)new TestPhoneContactBuilder((ArchetypeService)this.getArchetypeService()).name("Joe")).areaCode("03").phone("9444 5555").build();
        Contact contact3 = new TestPhoneContactBuilder((ArchetypeService)this.getArchetypeService()).areaCode("03").phone("9444 5555").build();
        try {
            this.checkAbbreviatePhone(contact1, false, 3, null);
            Assert.fail();
        }
        catch (IllegalArgumentException exception) {
            Assert.assertEquals((Object)"Minimum abbreviation width is 4", (Object)exception.getMessage());
        }
        this.checkAbbreviatePhone(contact1, false, 4, "(...");
        this.checkAbbreviatePhone(contact1, false, 10, "(03) 94...");
        this.checkAbbreviatePhone(contact1, false, 13, "(03) 9444 ...");
        this.checkAbbreviatePhone(contact1, false, 14, "(03) 9444 5555");
        this.checkAbbreviatePhone(contact1, false, 16, "(03) 9444 5555");
        this.checkAbbreviatePhone(contact1, true, 4, "(...");
        this.checkAbbreviatePhone(contact1, true, 14, "(03) 9444 5...");
        this.checkAbbreviatePhone(contact1, true, 16, "(03) 9444 555...");
        this.checkAbbreviatePhone(contact1, true, 17, "(03) 9444 5555...");
        this.checkAbbreviatePhone(contact1, true, 18, "(03) 9444 5555 ...");
        this.checkAbbreviatePhone(contact1, true, 20, "(03) 9444 5555 (...)");
        this.checkAbbreviatePhone(contact1, true, 22, "(03) 9444 5555 (Jo...)");
        this.checkAbbreviatePhone(contact2, true, 19, "(03) 9444 5555 ...");
        this.checkAbbreviatePhone(contact2, true, 20, "(03) 9444 5555 (Joe)");
        this.checkAbbreviatePhone(contact2, true, 25, "(03) 9444 5555 (Joe)");
        this.checkAbbreviatePhone(contact3, true, 19, "(03) 9444 5555");
        contact3.setName("");
        this.checkAbbreviatePhone(contact3, true, 19, "(03) 9444 5555");
        contact3.setName(null);
        this.checkAbbreviatePhone(contact3, true, 19, "(03) 9444 5555");
    }

    private void checkAbbreviatePhone(Contact contact, boolean includeName, int maxLength, String expected) {
        String actual = ContactHelper.abbreviatePhone((Contact)contact, (boolean)includeName, (int)maxLength, (PartyRules)this.rules, (ArchetypeService)this.getArchetypeService());
        Assert.assertTrue((actual.length() <= maxLength ? 1 : 0) != 0);
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

