/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.act;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.finance.account.FinancialTestHelper;
import org.openvpms.archetype.rules.patient.PatientTestHelper;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.object.Relationship;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.web.component.im.act.ActHelper;

public class ActHelperTestCase
extends ArchetypeServiceTest {
    @Test
    public void testGetTargetActs() {
        Party patient = TestHelper.createPatient();
        Act event = this.createAct("act.patientClinicalEvent", patient);
        Act note = this.createAct("act.patientClinicalNote", patient);
        Act problem = this.createProblem(patient);
        Act weight = this.createAct("act.patientWeight", patient);
        DocumentAct form = PatientTestHelper.createDocumentForm((Party)patient);
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        IMObjectBean bean = this.getBean((IMObject)event);
        relationships.add(bean.addTarget("items", (IMObject)note, "event"));
        relationships.add(bean.addTarget("items", (IMObject)problem, "events"));
        relationships.add(bean.addTarget("items", (IMObject)weight, "event"));
        relationships.add(bean.addTarget("items", (IMObject)form, "event"));
        this.save((IMObject[])new Act[]{event, note, problem, weight, form});
        List targetActs = ActHelper.getTargetActs(relationships);
        Assert.assertEquals((long)4L, (long)targetActs.size());
        Assert.assertTrue((boolean)targetActs.contains(note));
        Assert.assertTrue((boolean)targetActs.contains(problem));
        Assert.assertTrue((boolean)targetActs.contains(weight));
        Assert.assertTrue((boolean)targetActs.contains(form));
    }

    @Test
    public void testGetActs() {
        Party patient = TestHelper.createPatient();
        Act note = this.createAct("act.patientClinicalNote", patient);
        Act problem = this.createProblem(patient);
        Act weight = this.createAct("act.patientWeight", patient);
        FinancialAct invoiceItem = FinancialTestHelper.createInvoiceItem((Date)new Date(), (Party)patient, null, (Product)TestHelper.createProduct(), (BigDecimal)BigDecimal.ONE, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO, (BigDecimal)BigDecimal.ZERO);
        DocumentAct form = PatientTestHelper.createDocumentForm((Party)patient);
        this.save((IMObject[])new Act[]{note, problem, weight, invoiceItem, form});
        ArrayList<Reference> refs = new ArrayList<Reference>();
        refs.add(note.getObjectReference());
        refs.add(problem.getObjectReference());
        refs.add(weight.getObjectReference());
        refs.add(invoiceItem.getObjectReference());
        refs.add(form.getObjectReference());
        List acts = ActHelper.getActs(refs);
        Assert.assertEquals((long)5L, (long)acts.size());
        Assert.assertTrue((boolean)acts.contains(note));
        Assert.assertTrue((boolean)acts.contains(problem));
        Assert.assertTrue((boolean)acts.contains(weight));
        Assert.assertTrue((boolean)acts.contains(invoiceItem));
        Assert.assertTrue((boolean)acts.contains(form));
    }

    private Act createProblem(Party patient) {
        Act act = this.createAct("act.patientClinicalProblem", patient);
        Lookup lookup = TestHelper.getLookup((String)"lookup.diagnosis", (String)"HEART_MURMUR");
        act.setReason(lookup.getCode());
        return act;
    }

    private Act createAct(String shortName, Party patient) {
        Act result = (Act)this.create(shortName, Act.class);
        IMObjectBean bean = this.getBean((IMObject)result);
        bean.setTarget("patient", (IMObject)patient);
        return result;
    }
}

