/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.app;

import java.util.function.BiConsumer;
import java.util.function.Function;
import org.junit.Assert;
import org.junit.Test;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.DelegatingContext;
import org.openvpms.web.component.app.LocalContext;

public class DelegatingContextTestCase
extends ArchetypeServiceTest {
    @Test
    public void testAccessors() {
        this.check((Function)Context::getAppointment, (BiConsumer)Context::setAppointment, (Object)"act.customerAppointment", (Object)Act.class);
        this.check((Function)Context::getClinician, (BiConsumer)Context::setClinician, (Object)"security.user", (Object)User.class);
        this.check((Function)Context::getCustomer, (BiConsumer)Context::setCustomer, (Object)"party.customerperson", (Object)Party.class);
        this.check(Context::getCurrent, Context::setCurrent, this.create("party.customerperson"), this.create("party.customerperson"));
        this.check((Function)Context::getDepartment, (BiConsumer)Context::setDepartment, (Object)"entity.department", (Object)Entity.class);
        this.check((Function)Context::getDeposit, (BiConsumer)Context::setDeposit, (Object)"party.organisationDeposit", (Object)Party.class);
        this.check((Function)Context::getLocation, (BiConsumer)Context::setLocation, (Object)"party.organisationLocation", (Object)Party.class);
        this.check((Function)Context::getPatient, (BiConsumer)Context::setPatient, (Object)"party.patientpet", (Object)Party.class);
        this.check((Function)Context::getPractice, (BiConsumer)Context::setPractice, (Object)"party.organisationPractice", (Object)Party.class);
        this.check((Function)Context::getProduct, (BiConsumer)Context::setProduct, (Object)"product.medication", (Object)Product.class);
        this.check((Function)Context::getSchedule, (BiConsumer)Context::setSchedule, (Object)"party.organisationSchedule", (Object)Party.class);
        this.check(Context::getScheduleDate, Context::setScheduleDate, DateRules.getToday(), DateRules.getTomorrow());
        this.check((Function)Context::getScheduleView, (BiConsumer)Context::setScheduleView, (Object)"entity.organisationScheduleView", (Object)Entity.class);
        this.check((Function)Context::getStockLocation, (BiConsumer)Context::setStockLocation, (Object)"party.organisationStockLocation", (Object)Party.class);
        this.check((Function)Context::getSupplier, (BiConsumer)Context::setSupplier, (Object)"party.supplierperson", (Object)Party.class);
        this.check((Function)Context::getTask, (BiConsumer)Context::setTask, (Object)"act.customerTask", (Object)Act.class);
        this.check((Function)Context::getTerminal, (BiConsumer)Context::setTerminal, (Object)"entity.EFTPOSTerminalTest", (Object)Entity.class);
        this.check((Function)Context::getTill, (BiConsumer)Context::setTill, (Object)"party.organisationTill", (Object)Entity.class);
        this.check((Function)Context::getUser, (BiConsumer)Context::setUser, (Object)"security.user", (Object)User.class);
        this.check((Function)Context::getWorkList, (BiConsumer)Context::setWorkList, (Object)"party.organisationWorkList", (Object)Entity.class);
        this.check(Context::getWorkListDate, Context::setWorkListDate, DateRules.getToday(), DateRules.getTomorrow());
        this.check((Function)Context::getWorkListView, (BiConsumer)Context::setWorkListView, (Object)"entity.organisationWorkListView", (Object)Entity.class);
    }

    @Test
    public void testAddRemoveObject() {
        LocalContext fallback = new LocalContext();
        DelegatingContext context = new DelegatingContext((Context)new LocalContext(), (Context)fallback){};
        Product product1 = (Product)this.create("product.medication", Product.class);
        Product product2 = (Product)this.create("product.merchandise", Product.class);
        context.addObject((IMObject)product1);
        fallback.addObject((IMObject)product2);
        Assert.assertEquals((Object)product1, (Object)context.getProduct());
        context.removeObject((IMObject)product1);
        Assert.assertEquals((Object)product2, (Object)context.getProduct());
        fallback.removeObject((IMObject)product2);
        Assert.assertNull((Object)context.getProduct());
    }

    private <T extends IMObject> void check(Function<Context, T> getter, BiConsumer<Context, T> setter, String archetype, Class<T> type) {
        IMObject object1 = this.create(archetype, type);
        IMObject object2 = this.create(archetype, type);
        this.check(getter, setter, object1, object2);
    }

    private <T> void check(Function<Context, T> getter, BiConsumer<Context, T> setter, T object1, T object2) {
        LocalContext fallback = new LocalContext();
        DelegatingContext context = new DelegatingContext((Context)new LocalContext(), (Context)fallback){};
        Assert.assertNull(getter.apply((Context)context));
        setter.accept((Context)context, (Context)object1);
        Assert.assertEquals(object1, getter.apply((Context)context));
        setter.accept((Context)fallback, (Context)object2);
        Assert.assertEquals(object2, getter.apply((Context)fallback));
        Assert.assertEquals(object1, getter.apply((Context)context));
        setter.accept((Context)context, null);
        Assert.assertEquals(object2, getter.apply((Context)context));
    }
}

