/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.oauth;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.web.security.oauth.OAuth2AuthorizationResponseUtils;
import org.springframework.security.authentication.AuthenticationDetailsSource;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextHolderStrategy;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.authentication.OAuth2AuthorizationCodeAuthenticationToken;
import org.springframework.security.oauth2.client.oidc.authentication.OidcIdTokenDecoderFactory;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.security.oauth2.client.registration.ClientRegistrationRepository;
import org.springframework.security.oauth2.client.web.AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.HttpSessionOAuth2AuthorizationRequestRepository;
import org.springframework.security.oauth2.client.web.OAuth2AuthorizedClientRepository;
import org.springframework.security.oauth2.core.OAuth2AuthenticationException;
import org.springframework.security.oauth2.core.OAuth2AuthorizationException;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationExchange;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationRequest;
import org.springframework.security.oauth2.core.endpoint.OAuth2AuthorizationResponse;
import org.springframework.security.oauth2.jwt.Jwt;
import org.springframework.security.oauth2.jwt.JwtDecoder;
import org.springframework.security.web.DefaultRedirectStrategy;
import org.springframework.security.web.RedirectStrategy;
import org.springframework.security.web.authentication.WebAuthenticationDetailsSource;
import org.springframework.security.web.authentication.preauth.PreAuthenticatedAuthenticationToken;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.savedrequest.SavedRequest;
import org.springframework.security.web.util.UrlUtils;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.filter.OncePerRequestFilter;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

public class PrincipalResolvingOAuth2AuthorizationCodeGrantFilter
extends OncePerRequestFilter {
    private final ClientRegistrationRepository clientRegistrationRepository;
    private final OAuth2AuthorizedClientRepository authorizedClientRepository;
    private final AuthenticationManager authenticationManager;
    private final AuthenticationDetailsSource<HttpServletRequest, ?> authenticationDetailsSource = new WebAuthenticationDetailsSource();
    private final RedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
    private SecurityContextHolderStrategy securityContextHolderStrategy = SecurityContextHolder.getContextHolderStrategy();
    private AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository = new HttpSessionOAuth2AuthorizationRequestRepository();
    private RequestCache requestCache = new HttpSessionRequestCache();

    public PrincipalResolvingOAuth2AuthorizationCodeGrantFilter(ClientRegistrationRepository clientRegistrationRepository, OAuth2AuthorizedClientRepository authorizedClientRepository, AuthenticationManager authenticationManager) {
        Assert.notNull((Object)clientRegistrationRepository, (String)"clientRegistrationRepository cannot be null");
        Assert.notNull((Object)authorizedClientRepository, (String)"authorizedClientRepository cannot be null");
        Assert.notNull((Object)authenticationManager, (String)"authenticationManager cannot be null");
        this.clientRegistrationRepository = clientRegistrationRepository;
        this.authorizedClientRepository = authorizedClientRepository;
        this.authenticationManager = authenticationManager;
    }

    public final void setAuthorizationRequestRepository(AuthorizationRequestRepository<OAuth2AuthorizationRequest> authorizationRequestRepository) {
        Assert.notNull(authorizationRequestRepository, (String)"authorizationRequestRepository cannot be null");
        this.authorizationRequestRepository = authorizationRequestRepository;
    }

    public final void setRequestCache(RequestCache requestCache) {
        Assert.notNull((Object)requestCache, (String)"requestCache cannot be null");
        this.requestCache = requestCache;
    }

    public void setSecurityContextHolderStrategy(SecurityContextHolderStrategy securityContextHolderStrategy) {
        Assert.notNull((Object)securityContextHolderStrategy, (String)"securityContextHolderStrategy cannot be null");
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.matchesAuthorizationResponse(request)) {
            this.processAuthorizationResponse(request, response);
            return;
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }

    private boolean matchesAuthorizationResponse(HttpServletRequest request) {
        MultiValueMap<String, String> params = OAuth2AuthorizationResponseUtils.toMultiMap(request.getParameterMap());
        if (!OAuth2AuthorizationResponseUtils.isAuthorizationResponse(params)) {
            return false;
        }
        OAuth2AuthorizationRequest authorizationRequest = this.authorizationRequestRepository.loadAuthorizationRequest(request);
        if (authorizationRequest == null) {
            return false;
        }
        UriComponents requestUri = UriComponentsBuilder.fromUriString((String)UrlUtils.buildFullRequestUrl((HttpServletRequest)request)).build();
        UriComponents redirectUri = UriComponentsBuilder.fromUriString((String)authorizationRequest.getRedirectUri()).build();
        LinkedHashSet requestUriParameters = new LinkedHashSet(requestUri.getQueryParams().entrySet());
        LinkedHashSet redirectUriParameters = new LinkedHashSet(redirectUri.getQueryParams().entrySet());
        requestUriParameters.retainAll(redirectUriParameters);
        if (Objects.equals(requestUri.getScheme(), redirectUri.getScheme()) && Objects.equals(requestUri.getUserInfo(), redirectUri.getUserInfo()) && Objects.equals(requestUri.getHost(), redirectUri.getHost()) && Objects.equals(requestUri.getPort(), redirectUri.getPort()) && Objects.equals(requestUri.getPath(), redirectUri.getPath()) && Objects.equals(((Object)requestUriParameters).toString(), ((Object)redirectUriParameters).toString())) {
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Request URI=" + requestUri + " does not match Redirect URI=" + redirectUri));
        }
        return false;
    }

    private void processAuthorizationResponse(HttpServletRequest request, HttpServletResponse response) throws IOException {
        OAuth2AuthorizationRequest authorizationRequest = this.authorizationRequestRepository.removeAuthorizationRequest(request, response);
        String registrationId = (String)authorizationRequest.getAttribute("registration_id");
        this.logger.debug((Object)("Processing authorization response for Client Registration: " + registrationId));
        ClientRegistration clientRegistration = this.clientRegistrationRepository.findByRegistrationId(registrationId);
        MultiValueMap<String, String> params = OAuth2AuthorizationResponseUtils.toMultiMap(request.getParameterMap());
        String redirectUri = UrlUtils.buildFullRequestUrl((HttpServletRequest)request);
        OAuth2AuthorizationResponse authorizationResponse = OAuth2AuthorizationResponseUtils.convert(params, redirectUri);
        OAuth2AuthorizationCodeAuthenticationToken authenticationRequest = new OAuth2AuthorizationCodeAuthenticationToken(clientRegistration, new OAuth2AuthorizationExchange(authorizationRequest, authorizationResponse));
        authenticationRequest.setDetails(this.authenticationDetailsSource.buildDetails((Object)request));
        try {
            Authentication authentication = this.authenticate(authenticationRequest, request, response);
            this.securityContextHolderStrategy.getContext().setAuthentication(authentication);
        }
        catch (OAuth2AuthenticationException ex) {
            this.securityContextHolderStrategy.clearContext();
            OAuth2Error error = ex.getError();
            UriComponentsBuilder uriBuilder = UriComponentsBuilder.fromUriString((String)authorizationRequest.getRedirectUri()).queryParam("error", new Object[]{error.getErrorCode()});
            if (!StringUtils.isEmpty((CharSequence)error.getDescription())) {
                uriBuilder.queryParam("error_description", new Object[]{error.getDescription()});
            }
            if (!StringUtils.isEmpty((CharSequence)error.getUri())) {
                uriBuilder.queryParam("error_uri", new Object[]{error.getUri()});
            }
            this.logger.error((Object)("OAuth2 handshake failed: " + ex.getMessage()), (Throwable)ex);
            this.redirectStrategy.sendRedirect(request, response, uriBuilder.build().encode().toString());
            return;
        }
        String redirectUrl = authorizationRequest.getRedirectUri();
        SavedRequest savedRequest = this.requestCache.getRequest(request, response);
        if (savedRequest != null) {
            redirectUrl = savedRequest.getRedirectUrl();
            this.requestCache.removeRequest(request, response);
        }
        this.redirectStrategy.sendRedirect(request, response, redirectUrl);
    }

    private Authentication authenticate(OAuth2AuthorizationCodeAuthenticationToken authenticationRequest, HttpServletRequest request, HttpServletResponse response) {
        Authentication authentication;
        try {
            OAuth2AuthorizationCodeAuthenticationToken authenticationResult = (OAuth2AuthorizationCodeAuthenticationToken)this.authenticationManager.authenticate((Authentication)authenticationRequest);
            authentication = this.getAuthentication(authenticationResult);
            String principalName = authentication.getName();
            OAuth2AuthorizedClient authorizedClient = new OAuth2AuthorizedClient(authenticationResult.getClientRegistration(), principalName, authenticationResult.getAccessToken(), authenticationResult.getRefreshToken());
            this.authorizedClientRepository.saveAuthorizedClient(authorizedClient, authentication, request, response);
        }
        catch (OAuth2AuthenticationException exception) {
            throw exception;
        }
        catch (OAuth2AuthorizationException exception) {
            throw new OAuth2AuthenticationException(exception.getError(), (Throwable)exception);
        }
        catch (Exception exception) {
            OAuth2Error error = new OAuth2Error("server_error", "Failed to process Client Registration '" + authenticationRequest.getClientRegistration().getRegistrationId() + "': " + exception.getMessage(), null);
            throw new OAuth2AuthenticationException(error, (Throwable)exception);
        }
        return authentication;
    }

    private Authentication getAuthentication(OAuth2AuthorizationCodeAuthenticationToken authenticationResult) {
        ClientRegistration clientRegistration = authenticationResult.getClientRegistration();
        JwtDecoder decoder = new OidcIdTokenDecoderFactory().createDecoder(clientRegistration);
        String idToken = (String)authenticationResult.getAdditionalParameters().get("id_token");
        if (StringUtils.isEmpty((CharSequence)idToken)) {
            OAuth2Error error = new OAuth2Error("invalid_token", "Missing (required) ID Token in Token Response for Client Registration: " + clientRegistration.getRegistrationId(), null);
            throw new OAuth2AuthorizationException(error, error.toString());
        }
        Jwt jwt = decoder.decode(idToken);
        String email = jwt.getClaimAsString("email");
        if (StringUtils.isEmpty((CharSequence)email)) {
            OAuth2Error error = new OAuth2Error("invalid_token", "Missing email in Token Response for Client Registration: " + clientRegistration.getRegistrationId(), null);
            throw new OAuth2AuthorizationException(error, error.toString());
        }
        return new PreAuthenticatedAuthenticationToken((Object)email, null, Collections.emptyList());
    }
}

