/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.oauth;

import org.openvpms.web.security.oauth.OAuth2SessionSecurityContextHolderStrategy;
import org.springframework.security.core.Authentication;
import org.springframework.security.oauth2.core.OAuth2Error;

public class OAuth2ResponseManager {
    private final OAuth2SessionSecurityContextHolderStrategy securityContextHolderStrategy;
    private OAuth2Error error;

    public OAuth2ResponseManager(OAuth2SessionSecurityContextHolderStrategy securityContextHolderStrategy) {
        this.securityContextHolderStrategy = securityContextHolderStrategy;
    }

    public String getEmail() {
        String result = null;
        if (this.error == null) {
            Authentication authentication = this.securityContextHolderStrategy.getContext().getAuthentication();
            result = authentication != null ? authentication.getName() : null;
        }
        return result;
    }

    public OAuth2Error getError() {
        return this.error;
    }

    public void error(String code, String description, String uri) {
        this.error = new OAuth2Error(code, description, uri);
        this.securityContextHolderStrategy.clearContext();
    }

    public void success() {
        this.error = null;
    }

    public void clear() {
        this.error = null;
        this.securityContextHolderStrategy.clearContext();
    }
}

