/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.security.mail;

import org.openvpms.archetype.rules.practice.MailServer;
import org.openvpms.component.security.crypto.PasswordEncryptor;
import org.springframework.security.oauth2.client.OAuth2AuthorizeRequest;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClient;
import org.springframework.security.oauth2.client.OAuth2AuthorizedClientManager;

public class MailPasswordResolver {
    private final OAuth2AuthorizedClientManager clientManager;
    private final PasswordEncryptor encryptor;

    public MailPasswordResolver(OAuth2AuthorizedClientManager clientManager, PasswordEncryptor encryptor) {
        this.clientManager = clientManager;
        this.encryptor = encryptor;
    }

    public String getPassword(MailServer settings) {
        String password;
        OAuth2AuthorizeRequest request;
        OAuth2AuthorizedClient client;
        String result = settings.getAuthenticationMethod() == MailServer.AuthenticationMethod.OAUTH2 ? ((client = this.clientManager.authorize(request = OAuth2AuthorizeRequest.withClientRegistrationId((String)settings.getOauthClientRegistrationId()).principal(settings.getUsername()).build())) != null ? client.getAccessToken().getTokenValue() : null) : ((password = settings.getPassword()) != null ? this.encryptor.decrypt(password) : null);
        return result;
    }
}

