/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.workspace.AbstractCRUDWorkspace;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public abstract class BasicCRUDWorkspace<T extends IMObject>
extends AbstractCRUDWorkspace<T, T> {
    public BasicCRUDWorkspace(String id, Context context) {
        this(id, null, context);
    }

    public BasicCRUDWorkspace(String id, Archetypes<T> archetypes, Context context) {
        super(id, archetypes, archetypes, context);
    }

    public BasicCRUDWorkspace(String id, Archetypes<T> archetypes, Context context, boolean showSelector) {
        super(id, archetypes, archetypes, context, showSelector);
    }

    @Override
    public void setObject(T object) {
        super.setObject(object);
        this.getCRUDWindow().setObject(object);
    }

    @Override
    protected BrowserDialog<T> createBrowserDialog(Browser<T> browser, HelpContext help) {
        String title = Messages.format((String)"imobject.select.title", (Object[])new Object[]{this.getArchetypes().getDisplayName()});
        return new BrowserDialog<T>(title, browser, true, help);
    }

    @Override
    protected void onSelectClosed(BrowserDialog<T> dialog) {
        if (dialog.createNew()) {
            this.getCRUDWindow().create();
        } else {
            IMObject object = (IMObject)dialog.getSelected();
            if (object != null) {
                this.onSelected(object);
            }
        }
    }

    @Override
    protected void onSaved(T object, boolean isNew) {
        this.setObject(object);
    }

    @Override
    protected void onDeleted(T object) {
        this.setObject(null);
    }

    @Override
    protected void onRefresh(T object) {
        object = object != null && object.isNew() ? null : IMObjectHelper.reload(object);
        this.setObject(object);
    }

    @Override
    protected void setArchetypes(Archetypes<T> archetypes) {
        super.setArchetypes(archetypes);
        this.setChildArchetypes(archetypes);
    }
}

