/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import nextapp.echo2.app.Button;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.ActActions;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.print.IMPrinter;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.print.BasicPrinterListener;
import org.openvpms.web.component.workspace.AbstractViewCRUDWindow;
import org.openvpms.web.component.workspace.ActPoster;
import org.openvpms.web.component.workspace.CRUDWindowListener;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.factory.ButtonFactory;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;

public abstract class ActCRUDWindow<T extends Act>
extends AbstractViewCRUDWindow<T> {
    public static final String POST_ID = "button.post";
    private boolean posted;

    public ActCRUDWindow(Archetypes<T> archetypes, ActActions<T> actions, Context context, HelpContext help) {
        super(archetypes, actions, context, help);
    }

    @Override
    public void setObject(T object) {
        this.posted = object != null && "POSTED".equals(object.getStatus());
        super.setObject(object);
    }

    @Override
    public void edit() {
        Act act = (Act)this.getObject();
        if (act != null) {
            if (((ActActions)this.getActions()).canEdit(act)) {
                super.edit();
            } else {
                this.showStatusError(act, "act.noedit.title", "act.noedit.message");
            }
        }
    }

    @Override
    protected void deleteDisallowed(T object) {
        this.showStatusError((Act)object, "act.nodelete.title", "act.nodelete.message");
    }

    @Override
    protected ActActions<T> getActions() {
        return (ActActions)super.getActions();
    }

    protected void onPost(T object) {
        IMObjectActions actions = this.getActions();
        if (((ActActions)actions).canPost(object)) {
            ActPoster<Act> poster = this.getActPoster(object);
            poster.post(latest -> {
                if ("POSTED".equals(latest.getStatus())) {
                    this.saved(latest);
                    this.onPosted(latest);
                } else {
                    this.onRefresh(latest);
                }
            });
        } else {
            this.onRefresh(object);
        }
    }

    @Override
    protected void onSaved(T object, boolean isNew) {
        boolean prevPosted = this.posted && !isNew;
        super.onSaved(object, isNew);
        String status = object.getStatus();
        if (!prevPosted && "POSTED".equals(status)) {
            this.onPosted(object);
        }
    }

    protected void onPosted(T act) {
    }

    @Override
    protected void print(T object) {
        IMObjectActions actions = this.getActions();
        if (((ActActions)actions).isUnfinalised((Act)object) && ((ActActions)actions).warnWhenPrintingUnfinalisedAct()) {
            String displayName = this.getDisplayName((IMObject)object);
            String title = Messages.format((String)"print.unfinalised.title", (Object[])new Object[]{displayName});
            String message = Messages.format((String)"print.unfinalised.message", (Object[])new Object[]{displayName});
            ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener((Act)object){
                final /* synthetic */ Act val$object;
                {
                    this.val$object = act;
                }

                public void onYes() {
                    ActCRUDWindow.super.print((IMObject)this.val$object);
                }
            });
        } else {
            super.print(object);
        }
    }

    @Override
    protected void mail(T object) {
        IMObjectActions actions = this.getActions();
        if (((ActActions)actions).isUnfinalised((Act)object) && ((ActActions)actions).warnWhenPrintingUnfinalisedAct()) {
            String displayName = this.getDisplayName((IMObject)object);
            String title = Messages.format((String)"mail.unfinalised.title", (Object[])new Object[]{displayName});
            String message = Messages.format((String)"mail.unfinalised.message", (Object[])new Object[]{displayName});
            ConfirmationDialog.show((String)title, (String)message, (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener((Act)object){
                final /* synthetic */ Act val$object;
                {
                    this.val$object = act;
                }

                public void onYes() {
                    ActCRUDWindow.super.mail((IMObject)this.val$object);
                }
            });
        } else {
            super.mail(object);
        }
    }

    @Override
    protected IMPrinter<T> createPrinter(T object) {
        InteractiveIMPrinter printer = (InteractiveIMPrinter)super.createPrinter(object);
        printer.setListener(new BasicPrinterListener((Act)object){
            final /* synthetic */ Act val$object;
            {
                this.val$object = act;
            }

            @Override
            public void printed(DocumentPrinter printer) {
                Act saved = ((ActActions)ActCRUDWindow.this.getActions()).setPrinted(this.val$object);
                if (saved != null) {
                    ActCRUDWindow.this.saved(saved);
                }
            }
        });
        return printer;
    }

    protected void showStatusError(Act act, String titleKey, String messageKey) {
        ArchetypeDescriptor descriptor = this.getArchetypeDescriptor();
        String name = descriptor != null ? descriptor.getDisplayName() : act.getArchetype();
        String status = act.getStatus();
        String title = Messages.format((String)titleKey, (Object[])new Object[]{name});
        String message = Messages.format((String)messageKey, (Object[])new Object[]{name, status});
        ErrorDialog.show((String)title, (String)message);
    }

    protected Button createPostButton() {
        return ButtonFactory.create((String)POST_ID, (Runnable)this.action(this::onPost, true, null));
    }

    protected ActPoster<T> getActPoster(T object) {
        HelpContext help = this.getHelpContext().subtopic("post");
        return new ActPoster<T>(object, this.getActions(), help);
    }

    private void saved(T act) {
        this.setObject(act);
        CRUDWindowListener<T> listener = this.getListener();
        if (listener != null) {
            listener.saved(act, false);
        }
    }
}

