/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.web.component.workspace.Workspace;
import org.openvpms.web.component.workspace.Workspaces;

public abstract class AbstractWorkspaces
implements Workspaces {
    private final String id;
    private final List<Workspace> workspaces = new ArrayList<Workspace>();
    private Workspace workspace;

    public AbstractWorkspaces(String id) {
        this.id = id;
    }

    @Override
    public String getTitleKey() {
        return "workspaces." + this.id;
    }

    public void addWorkspace(Workspace workspace) {
        this.workspaces.add(workspace);
    }

    @Override
    public Workspace getWorkspace() {
        return this.workspace;
    }

    @Override
    public void setWorkspace(Workspace workspace) {
        this.workspace = workspace;
    }

    @Override
    public Workspace getDefaultWorkspace() {
        return !this.workspaces.isEmpty() ? this.workspaces.get(0) : null;
    }

    @Override
    public List<Workspace> getWorkspaces() {
        return this.workspaces;
    }

    @Override
    public Workspace getWorkspaceForArchetype(String shortName) {
        for (Workspace workspace : this.workspaces) {
            if (!workspace.canUpdate(shortName)) continue;
            return workspace;
        }
        return null;
    }
}

