/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workspace;

import java.util.List;
import nextapp.echo2.app.Component;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.DefaultContextSwitchListener;
import org.openvpms.web.component.im.archetype.Archetypes;
import org.openvpms.web.component.im.edit.IMObjectActions;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.component.workspace.AbstractCRUDWindow;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.help.HelpContext;

public abstract class AbstractViewCRUDWindow<T extends IMObject>
extends AbstractCRUDWindow<T> {
    protected static final String STYLE = "CRUDWindow";
    private final Component objectContainer = ColumnFactory.create();
    private IMObjectViewer viewer;

    public AbstractViewCRUDWindow(Archetypes<T> archetypes, IMObjectActions<T> actions, Context context, HelpContext help) {
        super(archetypes, actions, context, help);
    }

    @Override
    public void setObject(T object) {
        super.setObject(object);
        this.objectContainer.removeAll();
        this.view(object);
    }

    @Override
    public void edit() {
        if (this.viewer != null) {
            this.setSelectionPath(this.viewer.getSelectionPath());
        }
        super.edit();
    }

    @Override
    public void setSelectionPath(List<Selection> path) {
        super.setSelectionPath(path);
        if (path != null && this.viewer != null) {
            this.viewer.setSelectionPath(path);
        }
    }

    protected void view(T object) {
        this.viewer = null;
        if (object != null) {
            this.viewer = this.createViewer((IMObject)object);
            this.objectContainer.add(this.viewer.getComponent());
        }
    }

    protected IMObjectViewer createViewer(IMObject object) {
        LayoutContext context = this.createViewLayoutContext();
        return new IMObjectViewer(object, null, context);
    }

    protected LayoutContext createViewLayoutContext() {
        DefaultLayoutContext context = new DefaultLayoutContext(this.getContext(), this.getHelpContext());
        context.setMailContext(this.getMailContext());
        context.setContextSwitchListener(DefaultContextSwitchListener.INSTANCE);
        return context;
    }

    protected Component getContainer() {
        return this.objectContainer;
    }

    @Override
    protected Component doLayout() {
        super.doLayout();
        return SplitPaneFactory.create((int)6, (String)STYLE, (Component[])new Component[]{this.getButtons().getContainer(), this.getContainer()});
    }

    protected IMObject getViewSelection() {
        List<Selection> path;
        IMObject result = null;
        if (this.viewer != null && !(path = this.viewer.getSelectionPath()).isEmpty()) {
            result = path.get(path.size() - 1).getObject();
        }
        return result;
    }
}

