/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.WorkflowImpl;
import org.openvpms.web.echo.help.HelpContext;

public class Tasks
extends AbstractTask {
    private final WorkflowImpl workflow;

    public Tasks(HelpContext help) {
        this.workflow = new WorkflowImpl(help);
    }

    public void addTask(Task task) {
        this.workflow.addTask(task);
    }

    public void setBreakOnSkip(boolean breakOnSkip) {
        this.workflow.setBreakOnSkip(breakOnSkip);
    }

    @Override
    public void start(TaskContext context) {
        this.workflow.addTaskListener(new DefaultTaskListener(){

            @Override
            public void taskEvent(TaskEvent event) {
                switch (event.getType()) {
                    case SKIPPED: {
                        Tasks.this.notifySkipped();
                        break;
                    }
                    case CANCELLED: {
                        Tasks.this.notifyCancelled();
                        break;
                    }
                    case COMPLETED: {
                        Tasks.this.notifyCompleted();
                    }
                }
            }
        });
        this.initialise(context);
        if (!this.isFinished()) {
            this.start(this.workflow, context);
        }
    }

    protected void initialise(TaskContext context) {
    }
}

