/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;

public class TaskListeners
implements TaskListener {
    private List<TaskListener> listeners;

    public void addListener(TaskListener listener) {
        if (this.listeners == null) {
            this.listeners = new ArrayList<TaskListener>();
        }
        this.listeners.add(listener);
    }

    public void removeListener(TaskListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void starting(Task task) {
        for (TaskListener listener : this.getListeners()) {
            listener.starting(task);
        }
    }

    @Override
    public void taskEvent(TaskEvent event) {
        for (TaskListener listener : this.getListeners()) {
            listener.taskEvent(event);
        }
    }

    private TaskListener[] getListeners() {
        return this.listeners != null ? this.listeners.toArray(new TaskListener[0]) : new TaskListener[]{};
    }
}

