/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openvpms.web.component.workflow.ConditionalTask;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.EvalTask;
import org.openvpms.web.component.workflow.NodeConditionTask;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;

public class TaskFactory {
    public static <T> EvalTask<Boolean> eq(String shortName, String node, T value) {
        return new NodeConditionTask<T>(shortName, node, value);
    }

    public static <T> EvalTask<Boolean> ne(String shortName, String node, T value) {
        return new NodeConditionTask<T>(shortName, node, false, value);
    }

    public static EvalTask<Boolean> and(EvalTask<Boolean> task1, EvalTask<Boolean> task2) {
        return new AndTask(task1, task2);
    }

    public static Task when(EvalTask<Boolean> condition, Task task) {
        return new ConditionalTask(condition, task);
    }

    public static Task when(EvalTask<Boolean> condition, Task task, Task elseTask) {
        return new ConditionalTask(condition, task, elseTask);
    }

    private static class AndTask
    extends EvalTask<Boolean> {
        List<EvalTask<Boolean>> tasks = new ArrayList<EvalTask<Boolean>>();
        private EvalTask<Boolean> current;
        private Iterator<EvalTask<Boolean>> iterator;

        public AndTask(EvalTask<Boolean> task1, EvalTask<Boolean> task2) {
            this.tasks.add(task1);
            this.tasks.add(task2);
        }

        @Override
        public void start(TaskContext context) {
            this.iterator = this.tasks.iterator();
            this.next(context);
        }

        private void next(final TaskContext context) {
            DefaultTaskListener listener = new DefaultTaskListener(){

                @Override
                public void taskEvent(TaskEvent event) {
                    switch (event.getType()) {
                        case SKIPPED: {
                            this.notifySkipped();
                            break;
                        }
                        case COMPLETED: {
                            boolean value;
                            boolean bl = value = current.getValue() != null && (Boolean)current.getValue() != false;
                            if (!value) {
                                this.setValue(false);
                                break;
                            }
                            if (iterator.hasNext()) {
                                this.next(context);
                                break;
                            }
                            this.setValue(true);
                            break;
                        }
                        default: {
                            this.notifyCancelled();
                        }
                    }
                }
            };
            this.current = this.iterator.next();
            this.current.addTaskListener(listener);
            this.current.start(context);
        }
    }
}

