/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import java.util.Collection;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.IMObjectReportPrinter;
import org.openvpms.web.component.im.print.IMPrinterFactory;
import org.openvpms.web.component.im.print.InteractiveIMPrinter;
import org.openvpms.web.component.im.report.ContextDocumentTemplateLocator;
import org.openvpms.web.component.im.report.DocumentTemplateLocator;
import org.openvpms.web.component.print.PrinterListener;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.system.ServiceHelper;

public class PrintIMObjectsTask<T extends IMObject>
extends AbstractTask {
    private final Collection<T> objects;
    private final String shortName;

    public PrintIMObjectsTask(Collection<T> objects, String shortName) {
        this.objects = objects;
        this.shortName = shortName;
    }

    @Override
    public void start(TaskContext context) {
        boolean skip;
        boolean bl = skip = !this.isRequired();
        if (!this.objects.isEmpty()) {
            try {
                ContextDocumentTemplateLocator locator = new ContextDocumentTemplateLocator(this.shortName, (Context)context);
                IMPrinterFactory factory = ServiceHelper.getBean(IMPrinterFactory.class);
                IMObjectReportPrinter<T> printer = factory.createIMObjectReportPrinter(this.objects, (DocumentTemplateLocator)locator, (Context)context);
                InteractiveIMPrinter<T> iPrinter = new InteractiveIMPrinter<T>(printer, skip, (Context)context, context.getHelpContext());
                iPrinter.setListener(new PrinterListener(){

                    @Override
                    public void printed(DocumentPrinter printer) {
                        PrintIMObjectsTask.this.notifyCompleted();
                    }

                    @Override
                    public void cancelled() {
                        PrintIMObjectsTask.this.notifyCancelled();
                    }

                    @Override
                    public void skipped() {
                        PrintIMObjectsTask.this.notifySkipped();
                    }

                    @Override
                    public void failed(Throwable cause) {
                        PrintIMObjectsTask.this.notifyCancelledOnError(cause);
                    }
                });
                iPrinter.print();
            }
            catch (OpenVPMSException exception) {
                this.notifyCancelledOnError(exception);
            }
        } else {
            this.notifyCompleted();
        }
    }
}

