/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.delete.AsyncIMObjectDeletionListener;
import org.openvpms.web.component.im.delete.IMObjectDeletionHandlerFactory;
import org.openvpms.web.component.im.delete.SilentIMObjectDeleter;
import org.openvpms.web.component.im.edit.EditDialog;
import org.openvpms.web.component.im.edit.EditDialogFactory;
import org.openvpms.web.component.im.edit.IMObjectEditor;
import org.openvpms.web.component.im.edit.IMObjectEditorSaver;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.CreateIMObjectTask;
import org.openvpms.web.component.workflow.DefaultTaskContext;
import org.openvpms.web.component.workflow.DefaultTaskListener;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskProperties;
import org.openvpms.web.echo.dialog.ErrorDialog;
import org.openvpms.web.echo.dialog.ErrorDialogBuilder;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class EditIMObjectTask
extends AbstractTask {
    private final boolean interactive;
    private IMObject object;
    private String shortName;
    private boolean create;
    private boolean skip;
    private boolean deleteOnCancelOrSkip;
    private TaskProperties createProperties;
    private boolean showEditorOnError = true;
    private IMObjectEditor editor;
    private EditDialog dialog;

    public EditIMObjectTask(String shortName) {
        this(shortName, false);
    }

    public EditIMObjectTask(String shortName, boolean create) {
        this(shortName, create, true);
    }

    public EditIMObjectTask(String shortName, boolean create, boolean interactive) {
        this.shortName = shortName;
        this.create = create;
        this.interactive = interactive;
    }

    public EditIMObjectTask(String shortName, TaskProperties createProperties, boolean interactive) {
        this.shortName = shortName;
        this.create = true;
        this.createProperties = createProperties;
        this.interactive = interactive;
    }

    public EditIMObjectTask(IMObject object) {
        this(object, true);
    }

    public EditIMObjectTask(IMObject object, boolean interactive) {
        this.object = object;
        this.interactive = interactive;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    public void setShowEditorOnError(boolean show) {
        this.showEditorOnError = show;
    }

    public void setDeleteOnCancelOrSkip(boolean delete) {
        this.deleteOnCancelOrSkip = delete;
    }

    @Override
    public void start(TaskContext context) {
        if (this.object == null) {
            if (this.create) {
                this.create(context);
            } else {
                this.edit(context);
            }
        } else {
            this.edit(this.object, context);
        }
    }

    public IMObjectEditor getEditor() {
        return this.editor;
    }

    public EditDialog getEditDialog() {
        return this.dialog;
    }

    protected void edit(TaskContext context) {
        IMObject object = context.getObject(this.shortName);
        if (object != null) {
            this.edit(object, context);
        } else {
            this.notifyCancelled();
        }
    }

    protected void create(final TaskContext context) {
        CreateIMObjectTask creator = new CreateIMObjectTask(this.shortName, this.createProperties);
        creator.addTaskListener(new DefaultTaskListener(){

            @Override
            public void taskEvent(TaskEvent event) {
                switch (event.getType()) {
                    case SKIPPED: {
                        EditIMObjectTask.this.notifySkipped();
                        break;
                    }
                    case CANCELLED: {
                        EditIMObjectTask.this.notifyCancelled();
                        break;
                    }
                    case COMPLETED: {
                        EditIMObjectTask.this.edit(context);
                    }
                }
            }
        });
        this.start(creator, context);
    }

    protected void edit(IMObject object, TaskContext context) {
        HelpContext help = context.getHelpContext().topic(object, "edit");
        context = new DefaultTaskContext(context, null, help);
        try {
            this.editor = this.createEditor(object, context);
            if (this.interactive) {
                this.interactiveEdit(this.editor, context);
            } else {
                this.backgroundEdit(this.editor, context);
            }
        }
        catch (Throwable exception) {
            this.onError(object, context, exception);
        }
    }

    protected void onError(IMObject object, TaskContext context, Throwable exception) {
        if (this.deleteOnCancelOrSkip) {
            this.delete(object, context, () -> this.notifyCancelledOnError(exception));
        } else {
            this.notifyCancelledOnError(exception);
        }
    }

    protected IMObjectEditor createEditor(IMObject object, TaskContext context) {
        LayoutContext layout = this.createLayoutContext(context);
        return layout.getEditorFactory().create(object, layout);
    }

    protected LayoutContext createLayoutContext(TaskContext context) {
        return new DefaultLayoutContext(true, (Context)context, context.getHelpContext());
    }

    protected void interactiveEdit(final IMObjectEditor editor, final TaskContext context) {
        context.setCurrent(this.object);
        this.dialog = this.createEditDialog(editor, this.skip, context);
        this.dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                context.setCurrent(null);
                String action = EditIMObjectTask.this.dialog.getAction();
                EditIMObjectTask.this.clear();
                EditIMObjectTask.this.onDialogClose(action, editor, context);
            }
        });
        this.dialog.show();
    }

    protected void onDialogClose(String action, IMObjectEditor editor, TaskContext context) {
        if ("ok".equals(action)) {
            this.onEditCompleted();
        } else if ("skip".equals(action)) {
            this.onEditSkipped(editor, context);
        } else {
            this.onEditCancelled(editor, context);
        }
    }

    protected void backgroundEdit(IMObjectEditor editor, TaskContext context) {
        context.setCurrent(null);
        editor.getComponent();
        this.edit(editor, context);
        this.clear();
        DefaultValidator validator = new DefaultValidator();
        if (editor.validate(validator)) {
            this.backgroundSave(editor, context);
        } else {
            this.showValidationError(validator);
            if (this.showEditorOnError) {
                this.interactiveEdit(editor, context);
            }
        }
    }

    protected void backgroundSave(IMObjectEditor editor, TaskContext context) {
        IMObjectEditorSaver saver = new IMObjectEditorSaver();
        if (saver.save(editor, () -> this.backgroundEditFailed(editor, context))) {
            this.notifyCompleted();
        }
    }

    protected void backgroundEditFailed(IMObjectEditor editor, TaskContext context) {
        this.onEditCancelled(editor, context);
    }

    protected void edit(IMObjectEditor editor, TaskContext context) {
    }

    protected EditDialog createEditDialog(IMObjectEditor editor, boolean skip, TaskContext context) {
        EditDialog dialog = ServiceHelper.getBean(EditDialogFactory.class).create(editor, context);
        dialog.addSkip(skip);
        return dialog;
    }

    protected void onEditCompleted() {
        this.clear();
        this.notifyCompleted();
    }

    protected void onEditSkipped(IMObjectEditor editor, TaskContext context) {
        this.clear();
        if (this.deleteOnCancelOrSkip) {
            this.delete(editor.getObject(), context, this::notifySkipped);
        } else {
            this.notifySkipped();
        }
    }

    protected void onEditCancelled(IMObjectEditor editor, TaskContext context) {
        this.clear();
        if (this.deleteOnCancelOrSkip) {
            this.delete(editor.getObject(), context, this::notifyCancelled);
        } else {
            this.notifyCancelled();
        }
    }

    protected void delete(IMObject object, TaskContext context, Runnable callback) {
        this.delete(object, context, callback, callback);
    }

    protected void delete(IMObject object, TaskContext context, final Runnable successCallback, final Runnable failedCallback) {
        if (object.isNew()) {
            successCallback.run();
        } else {
            try {
                object = IMObjectHelper.reload(object);
                if (object != null) {
                    IMObjectDeletionHandlerFactory factory = ServiceHelper.getBean(IMObjectDeletionHandlerFactory.class);
                    SilentIMObjectDeleter<IMObject> deleter = new SilentIMObjectDeleter<IMObject>(factory, (ArchetypeService)ServiceHelper.getArchetypeService());
                    AsyncIMObjectDeletionListener<IMObject> listener = new AsyncIMObjectDeletionListener<IMObject>(){

                        @Override
                        protected void completed() {
                            successCallback.run();
                        }

                        @Override
                        protected void failed() {
                            failedCallback.run();
                        }
                    };
                    deleter.delete(object, (Context)context, context.getHelpContext(), listener);
                } else {
                    successCallback.run();
                }
            }
            catch (OpenVPMSException exception) {
                ErrorHelper.show((Throwable)exception, failedCallback);
            }
        }
    }

    private void showValidationError(Validator validator) {
        String message;
        ValidatorError error = validator.getFirstError();
        String string = message = error != null ? error.toString() : null;
        if (error != null) {
            ErrorDialogBuilder builder = (ErrorDialogBuilder)ErrorDialog.newDialog().message(message);
            if (!this.showEditorOnError) {
                builder.listener(this::notifyCancelled);
            }
            builder.show();
        } else if (!this.showEditorOnError) {
            this.notifyCancelled();
        }
    }

    private void clear() {
        this.editor = null;
        this.dialog = null;
    }
}

