/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.action.ActionFactory;
import org.openvpms.web.component.action.ObjectCallBuilder;
import org.openvpms.web.component.workflow.SynchronousTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskProperties;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractUpdateIMObjectTask<T extends IMObject>
extends SynchronousTask {
    private final String archetype;
    private final boolean save;
    private final boolean retry;
    private final TaskProperties properties;
    private final ActionFactory actionFactory;
    private final ArchetypeService service;
    private boolean skipIfMissing;

    public AbstractUpdateIMObjectTask(String archetype, boolean save, boolean retry) {
        this(archetype, null, save, retry);
    }

    public AbstractUpdateIMObjectTask(String archetype, TaskProperties properties, boolean save, boolean retry) {
        this.archetype = archetype;
        this.properties = properties;
        this.save = save;
        this.retry = retry;
        this.actionFactory = ServiceHelper.getBean(ActionFactory.class);
        this.service = ServiceHelper.getArchetypeService();
    }

    public void skipIfMissing() {
        this.skipIfMissing = true;
    }

    @Override
    public void execute(TaskContext context) {
        ((ObjectCallBuilder)((ObjectCallBuilder)this.actionFactory.newAction().backgroundOnly().automaticRetry(this.retry ? 3 : 0).withObject(this.archetype, () -> this.getObject(context)).useLatestInstanceOnRetry()).skipIfMissing(this.skipIfMissing)).call(object -> this.update(object, context)).onFailure(this::notifyCancelled).run();
    }

    protected void update(T object, TaskContext context) {
        if (this.canUpdate(object, context)) {
            this.populate(object, context);
            if (this.save) {
                this.service.save(object);
            }
        }
        context.addObject((IMObject)object);
    }

    protected boolean canUpdate(T object, TaskContext context) {
        return true;
    }

    protected void populate(T object, TaskContext context) {
        if (this.properties != null) {
            this.populate((IMObject)object, this.properties, context);
        }
    }

    private T getObject(TaskContext context) {
        return (T)context.getObject(this.archetype);
    }
}

