/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.workflow;

import java.util.Collection;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.archetype.NodeDescriptor;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.component.workflow.Task;
import org.openvpms.web.component.workflow.TaskContext;
import org.openvpms.web.component.workflow.TaskEvent;
import org.openvpms.web.component.workflow.TaskListener;
import org.openvpms.web.component.workflow.TaskListeners;
import org.openvpms.web.component.workflow.TaskProperties;
import org.openvpms.web.component.workflow.TaskProperty;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractTask
implements Task {
    private final TaskListeners listeners = new TaskListeners();
    private boolean required = true;
    private boolean finished;

    @Override
    public void addTaskListener(TaskListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void removeTaskListener(TaskListener listener) {
        this.listeners.removeListener(listener);
    }

    public TaskListeners getTaskListeners() {
        return this.listeners;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    protected void start(Task task, TaskContext context) {
        this.notifyStarting(task);
        task.start(context);
    }

    protected void notifyStarting(Task task) {
        this.listeners.starting(task);
    }

    protected void notifySkipped() {
        this.notifyEvent(TaskEvent.Type.SKIPPED);
    }

    protected void notifyCompleted() {
        this.notifyEvent(TaskEvent.Type.COMPLETED);
    }

    protected void notifyCancelled() {
        this.notifyEvent(TaskEvent.Type.CANCELLED);
    }

    protected void notifyCancelledOnError(Throwable cause) {
        ErrorHelper.show(cause, this::notifyCancelled);
    }

    protected void populate(IMObject object, TaskProperties properties, TaskContext context) {
        Collection<TaskProperty> list = properties.getProperties();
        if (!list.isEmpty()) {
            IMObjectBean bean = this.getBean(object);
            for (TaskProperty property : list) {
                String name = property.getName();
                NodeDescriptor descriptor = bean.getNode(name);
                Object value = property.getValue(context);
                if (descriptor != null && descriptor.isCollection()) {
                    bean.addValue(name, (IMObject)value);
                    continue;
                }
                bean.setValue(name, value);
            }
        }
    }

    protected void notifyEvent(TaskEvent.Type type) {
        if (this.finished) {
            throw new IllegalStateException("Listener has already been notified");
        }
        this.finished = true;
        this.listeners.taskEvent(new TaskEvent(type, this));
    }

    protected void notifyEvent(TaskEvent.Type type, Task task) {
        if (task.isFinished()) {
            throw new IllegalStateException("Listener has already been notified");
        }
        this.listeners.taskEvent(new TaskEvent(type, task));
    }

    protected IMObjectBean getBean(IMObject object) {
        return ServiceHelper.getArchetypeService().getBean(object);
    }

    protected static String getType(String[] shortNames) {
        StringBuilder type = new StringBuilder();
        IArchetypeRuleService service = ServiceHelper.getArchetypeService();
        for (int i = 0; i < shortNames.length && i < 2; ++i) {
            if (i != 0) {
                type.append("/");
            }
            type.append(DescriptorHelper.getDisplayName((String)shortNames[i], (ArchetypeService)service));
        }
        if (shortNames.length > 2) {
            type.append("/...");
        }
        return type.toString();
    }
}

