/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.util;

import java.io.Serializable;
import org.apache.commons.text.StringEscapeUtils;
import org.hibernate.ObjectNotFoundException;
import org.hibernate.pretty.MessageHelper;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.error.ErrorFormatter;
import org.openvpms.web.component.error.ExceptionHelper;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHelper {
    private static final Logger log = LoggerFactory.getLogger(ErrorHelper.class);

    public static void show(String error) {
        ErrorHelper.show(null, error);
    }

    public static void show(String title, String error) {
        ErrorHelper.show(title, error, (Runnable)null);
    }

    public static void show(String error, Runnable listener) {
        ErrorHelper.show(null, error, listener);
    }

    public static void show(String title, String error, Runnable listener) {
        log.error(error);
        ErrorHandler.getInstance().error(title, error, null, listener);
    }

    public static void show(String title, Throwable error) {
        ErrorHelper.show(title, null, error);
    }

    public static void show(String title, String displayName, Throwable error) {
        ErrorHelper.show(title, displayName, (String)null, error);
    }

    public static void show(String title, String displayName, String context, Throwable error) {
        ErrorHelper.show(title, displayName, context, error, null);
    }

    public static void show(String title, String displayName, String context, Throwable error, Runnable listener) {
        String message;
        String logerror = message = ErrorFormatter.formatHTML(error, displayName);
        if (context != null) {
            logerror = Messages.format((String)"logging.error.messageandcontext", (Object[])new Object[]{message, context});
        }
        log.error(logerror, error);
        ErrorHandler.getInstance().error(title, message, true, error, listener);
    }

    public static void show(Throwable error) {
        ErrorHelper.show(error, true);
    }

    public static void show(Throwable error, HelpContext help) {
        ErrorHelper.show(error, true, help);
    }

    public static void show(Throwable error, boolean log) {
        ErrorHelper.show(error, log, null);
    }

    public static void show(Throwable error, boolean log, HelpContext help) {
        String message = ErrorFormatter.formatHTML(error);
        if (log) {
            ErrorHelper.log.error(message, error);
            if (help != null) {
                ErrorHelper.log.error("Called from: " + help);
            }
        }
        ErrorHandler.getInstance().error(null, message, true, error, null);
    }

    public static void show(Throwable error, Runnable listener) {
        ErrorHelper.show(null, error, listener);
    }

    public static void show(String title, Throwable error, Runnable listener) {
        String message = ErrorFormatter.formatHTML(error);
        log.error(StringEscapeUtils.unescapeHtml4((String)message), error);
        ErrorHandler.getInstance().error(title, message, true, error, listener);
    }

    public static void show(String title, String displayName, IMObject object, Throwable error) {
        ErrorHelper.show(title, displayName, object, error, null);
    }

    public static void show(String title, String displayName, IMObject object, Throwable error, Runnable listener) {
        Throwable cause = ExceptionHelper.getRootCause(error);
        if (displayName == null) {
            displayName = DescriptorHelper.getDisplayName((IMObject)object, (ArchetypeService)ServiceHelper.getArchetypeService());
        }
        if (ExceptionHelper.isModifiedExternally(cause)) {
            String message;
            boolean html = false;
            if (cause instanceof ObjectNotFoundException) {
                ObjectNotFoundException notFoundException = (ObjectNotFoundException)cause;
                Serializable identifier = notFoundException.getIdentifier();
                message = identifier != null && Long.toString(object.getId()).equals(identifier.toString()) ? Messages.format((String)"imobject.notfound", (Object[])new Object[]{displayName}) : Messages.format((String)"imobject.notfound", (Object[])new Object[]{MessageHelper.infoString((String)notFoundException.getEntityName(), (Serializable)identifier)});
            } else {
                message = ErrorFormatter.formatHTML(cause, displayName);
                html = true;
            }
            ErrorHandler.getInstance().error(title, message, html, null, listener);
        } else {
            String message = ErrorFormatter.formatHTML(error, displayName);
            ErrorHandler.getInstance().error(title, message, true, error, listener);
        }
    }
}

