/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.retry;

import org.openvpms.web.component.retry.AbstractRetryable;
import org.openvpms.web.component.retry.Retryable;
import org.openvpms.web.component.util.ErrorHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Retryer {
    public static final int DEFAULT_ATTEMPTS = 10;
    public static final long DEFAULT_DELAY = 1000L;
    private final Retryable action;
    private final Runnable thenAction;
    private final Runnable elseAction;
    private final int attempts;
    private long delay = 1000L;
    private int runs;
    private static final Logger log = LoggerFactory.getLogger(Retryer.class);

    public Retryer(Retryable action) {
        this(action, 10);
    }

    public Retryer(Retryable action, int attempts) {
        this(action, null, attempts);
    }

    public Retryer(Retryable action, Runnable thenAction) {
        this(action, thenAction, 10);
    }

    public Retryer(Retryable action, Runnable thenAction, int attempts) {
        this(action, thenAction, null, attempts);
    }

    public Retryer(Retryable action, Runnable thenAction, Runnable elseAction) {
        this(action, thenAction, elseAction, 10);
    }

    public Retryer(Retryable action, Runnable thenAction, Runnable elseAction, int attempts) {
        this.action = action;
        this.thenAction = thenAction;
        this.elseAction = elseAction;
        this.attempts = attempts;
    }

    public boolean start() {
        this.runs = 0;
        return this.run();
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public static boolean run(final Runnable action) {
        return Retryer.run(new AbstractRetryable(){

            @Override
            protected boolean runAction() {
                action.run();
                return true;
            }
        });
    }

    public static boolean run(Retryable action) {
        return Retryer.run(action, 10);
    }

    public static boolean run(Retryable action, int attempts) {
        Retryer retryer = new Retryer(action, attempts);
        return retryer.start();
    }

    protected boolean run() {
        boolean result = false;
        boolean success = false;
        for (int i = 0; i < this.attempts; ++i) {
            ++this.runs;
            try {
                if (this.action.run()) {
                    success = true;
                    break;
                }
                this.logAbort();
                break;
            }
            catch (Throwable exception) {
                if (this.runs >= this.attempts) {
                    this.logAbort(exception);
                    break;
                }
                this.logRetry(exception);
                this.delay();
                continue;
            }
        }
        if (success) {
            result = this.runThenAction();
        } else {
            this.runElseAction();
        }
        return result;
    }

    protected boolean runThenAction() {
        return this.runAction(this.thenAction);
    }

    protected boolean runElseAction() {
        return this.runAction(this.elseAction);
    }

    protected void logRetry(Throwable exception) {
        log.warn("Retrying " + this.action + " after " + this.runs + " attempts", exception);
    }

    protected void logAbort() {
        log.warn("Aborting " + this.action + " after " + this.runs + " attempts");
    }

    protected void logAbort(Throwable exception) {
        log.warn("Aborting " + this.action + " after " + this.runs + " attempts", exception);
        ErrorHelper.show(exception);
    }

    protected void delay() {
        try {
            Thread.sleep(this.delay);
        }
        catch (InterruptedException ignore) {
            Thread.currentThread().interrupt();
        }
    }

    private boolean runAction(Runnable action) {
        boolean result = true;
        if (action != null) {
            try {
                action.run();
            }
            catch (Throwable exception) {
                result = false;
                ErrorHelper.show(exception);
            }
        }
        return result;
    }
}

