/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.ArrayList;
import java.util.List;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.archetype.ValidationError;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.error.ErrorHandler;
import org.openvpms.web.resource.i18n.Messages;

public class ValidationHelper {
    public static List<ValidatorError> validate(IMObject object, ArchetypeService service) {
        ArrayList<ValidatorError> result = null;
        List errors = service.validate(object);
        if (!errors.isEmpty()) {
            result = new ArrayList<ValidatorError>();
            for (ValidationError error : errors) {
                result.add(new ValidatorError(error));
            }
        }
        return result;
    }

    public static void showError(Validator validator) {
        ValidationHelper.showError(null, validator, null);
    }

    public static void showError(String title, Validator validator, Runnable listener) {
        ValidationHelper.showError(title, validator, null, true, listener);
    }

    public static void showError(String title, Validator validator, String key, boolean formatted) {
        ValidationHelper.showError(title, validator, key, formatted, null);
    }

    public static void showError(String title, Validator validator, String key, boolean formatted, Runnable listener) {
        ValidatorError error = validator.getFirstError();
        if (error != null) {
            String message;
            String string = message = formatted ? error.toString() : error.getMessage();
            if (key != null) {
                message = Messages.format((String)key, (Object[])new Object[]{message});
            }
            ErrorHandler.getInstance().error(title, message, null, listener);
        }
    }
}

