/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.domain.im.common.IMObjectReference;
import org.openvpms.component.business.domain.im.datatypes.quantity.Money;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.property.AbstractProperty;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyTransformer;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.text.TextHelper;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class SimpleProperty
extends AbstractProperty {
    private final String name;
    private final Class<?> type;
    private String displayName;
    private String description;
    private Object value;
    private int minLength;
    private int maxLength = 255;
    private String[] shortNames = EMPTY;
    private boolean readOnly;
    private boolean hidden;
    private boolean required;
    private List<ValidatorError> validationErrors;
    private static final String[] EMPTY = new String[0];

    public SimpleProperty(String name, Class<?> type) {
        this(name, null, type);
    }

    public SimpleProperty(String name, Object value, Class<?> type) {
        this(name, value, type, null);
    }

    public SimpleProperty(String name, Object value, Class<?> type, boolean readOnly) {
        this(name, value, type, null, readOnly);
    }

    public SimpleProperty(String name, Object value, Class<?> type, String displayName) {
        this(name, value, type, displayName, false);
    }

    public SimpleProperty(String name, Object value, Class<?> type, String displayName, boolean readOnly) {
        this.name = name;
        this.value = value;
        this.type = type;
        this.displayName = displayName;
        this.readOnly = readOnly;
    }

    public SimpleProperty(Property property) {
        this.name = property.getName();
        this.type = property.getType();
        this.displayName = property.getDisplayName();
        this.description = property.getDescription();
        this.value = property.getValue();
        this.minLength = property.getMinLength();
        this.maxLength = property.getMaxLength();
        this.readOnly = property.isReadOnly();
        this.hidden = property.isHidden();
        this.required = property.isRequired();
        this.shortNames = property.getArchetypeRange();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        if (this.displayName == null) {
            this.displayName = TextHelper.unCamelCase((String)this.name);
        }
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public boolean setValue(Object value) {
        boolean set = false;
        this.checkModifiable();
        try {
            if (!Objects.equals(this.value, value)) {
                this.value = value = this.getTransformer().apply(value);
                set = true;
                this.modified();
            } else if (this.validationErrors != null) {
                this.modified();
            }
        }
        catch (OpenVPMSException exception) {
            this.invalidate(exception);
        }
        return set;
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public int getMinLength() {
        return this.minLength;
    }

    public void setMinLength(int length) {
        this.minLength = length;
    }

    @Override
    public int getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public boolean isBoolean() {
        return Boolean.class == this.type || Boolean.TYPE == this.type;
    }

    @Override
    public boolean isString() {
        return String.class == this.type;
    }

    @Override
    public boolean isNumeric() {
        return Number.class.isAssignableFrom(this.type) || Byte.TYPE == this.type || Short.TYPE == this.type || Integer.TYPE == this.type || Long.TYPE == this.type || Float.TYPE == this.type || Double.TYPE == this.type;
    }

    @Override
    public boolean isDate() {
        return Date.class == this.type;
    }

    @Override
    public boolean isMoney() {
        return Money.class == this.type;
    }

    @Override
    public boolean isObjectReference() {
        return IMObjectReference.class.isAssignableFrom(this.type);
    }

    @Override
    public boolean isLookup() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public String[] getArchetypeRange() {
        return this.shortNames;
    }

    public void setArchetypeRange(String ... shortNames) {
        this.shortNames = DescriptorHelper.getShortNames((String[])shortNames, (ArchetypeService)ServiceHelper.getArchetypeService());
    }

    @Override
    public boolean isDerived() {
        return false;
    }

    @Override
    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public NodeDescriptor getDescriptor() {
        return null;
    }

    public static Builder newProperty() {
        return new Builder();
    }

    @Override
    protected boolean doValidation(Validator validator) {
        List<ValidatorError> errors = null;
        if (this.validationErrors == null) {
            PropertyTransformer transformer = this.getTransformer();
            try {
                transformer.apply(this.getValue());
            }
            catch (OpenVPMSException exception) {
                this.invalidate(exception);
            }
        }
        if (this.validationErrors != null) {
            errors = this.validationErrors;
        } else if (this.isRequired() && this.getValue() == null) {
            this.validationErrors = new ArrayList<ValidatorError>();
            this.validationErrors.add(new ValidatorError(this, Messages.format((String)"property.error.required", (Object[])new Object[]{this.getDisplayName()})));
            errors = this.validationErrors;
        }
        if (errors != null) {
            validator.add((Modifiable)this, errors);
        }
        return errors == null;
    }

    private void invalidate(OpenVPMSException exception) {
        if (this.validationErrors != null) {
            this.validationErrors.clear();
        } else {
            this.validationErrors = new ArrayList<ValidatorError>();
        }
        Throwable cause = ExceptionUtils.getRootCause((Throwable)exception);
        if (cause == null) {
            cause = exception;
        }
        ValidatorError error = new ValidatorError(this, cause.getMessage());
        this.validationErrors.add(error);
        this.resetValid();
    }

    private void modified() {
        this.validationErrors = null;
        this.refresh();
    }

    public static class Builder {
        private String name;
        private Class<?> type;
        private String displayName;
        private String description;
        private String[] archetypeRange;
        private int minLength;
        private int maxLength = 255;
        private Object value;
        private boolean readOnly;
        private boolean hidden;
        private boolean required;
        private ModifiableListener listener;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder type(Class<?> type) {
            this.type = type;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder displayNameKey(String key) {
            return this.displayName(Messages.get((String)key));
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder archetypeRange(String ... archetypes) {
            this.archetypeRange = archetypes;
            return this;
        }

        public Builder minLength(int minLength) {
            this.minLength = minLength;
            return this;
        }

        public Builder maxLength(int maxLength) {
            this.maxLength = maxLength;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder readOnly() {
            this.readOnly = true;
            return this;
        }

        public Builder hidden() {
            this.hidden = true;
            return this;
        }

        public Builder required() {
            this.required = true;
            return this;
        }

        public Builder listener(ModifiableListener listener) {
            this.listener = listener;
            return this;
        }

        public SimpleProperty build() {
            if (this.type == null) {
                if (this.value != null) {
                    this.type = this.value.getClass();
                } else {
                    throw new IllegalStateException("Cannot determine property type");
                }
            }
            SimpleProperty property = new SimpleProperty(this.name, this.value, this.type, this.displayName, this.readOnly);
            property.setDescription(this.description);
            if (this.archetypeRange != null) {
                property.setArchetypeRange(this.archetypeRange);
            }
            property.setMinLength(this.minLength);
            property.setMaxLength(this.maxLength);
            property.setReadOnly(this.readOnly);
            property.setHidden(this.hidden);
            property.setRequired(this.required);
            if (this.listener != null) {
                property.addModifiableListener(this.listener);
            }
            return property;
        }
    }
}

