/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import org.openvpms.web.component.property.NumericPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.resource.i18n.Messages;

public class IntegerPropertyTransformer
extends NumericPropertyTransformer {
    private Integer min;
    private Integer max;

    public IntegerPropertyTransformer(Property property) {
        this(property, null, null);
    }

    public IntegerPropertyTransformer(Property property, int min, int max) {
        this(property, (Integer)min, (Integer)max);
    }

    public IntegerPropertyTransformer(Property property, Integer min, Integer max) {
        super(property);
        this.min = min;
        this.max = max;
        Class<Integer> type = property.getType();
        if (!type.isAssignableFrom(Integer.class)) {
            throw new IllegalArgumentException("Property '" + property.getName() + "' does not support Integer values");
        }
    }

    @Override
    protected Object convert(Object object, Property property) {
        if (object instanceof String) {
            try {
                return Integer.valueOf(object.toString());
            }
            catch (NumberFormatException exception) {
                String message = Messages.format((String)"property.error.invalidint", (Object[])new Object[]{property.getDisplayName()});
                throw new PropertyException(property, message, exception);
            }
        }
        if (object instanceof Number) {
            return ((Number)object).intValue();
        }
        return super.convert(object, property);
    }

    @Override
    protected void validate(Object object, Property property) {
        super.validate(object, property);
        if (this.min != null && ((Integer)object).compareTo(this.min) < 0) {
            String message = Messages.format((String)"property.error.min", (Object[])new Object[]{property.getDisplayName(), this.min});
            throw new PropertyException(property, message);
        }
        if (this.max != null && ((Integer)object).compareTo(this.max) > 0) {
            String message = Messages.format((String)"property.error.max", (Object[])new Object[]{property.getDisplayName(), this.max});
            throw new PropertyException(property, message);
        }
    }
}

