/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.property;

import java.text.ParseException;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.ValidationException;
import org.openvpms.web.component.property.AbstractPropertyTransformer;
import org.openvpms.web.component.property.Property;
import org.openvpms.web.component.property.PropertyException;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.resource.i18n.format.DateFormatter;

public abstract class AbstractDateTimePropertyTransformer
extends AbstractPropertyTransformer {
    private final Date minDate;
    private final Date maxDate;
    private final Format format;
    private boolean keepSeconds = true;

    public AbstractDateTimePropertyTransformer(Property property, Date min, Date max, Format format) {
        super(property);
        this.minDate = min;
        this.maxDate = max;
        this.format = format;
    }

    public Date getMinDate() {
        return this.minDate;
    }

    public Date getMaxDate() {
        return this.maxDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object apply(Object object) throws PropertyException {
        Date result;
        block8: {
            try {
                if (object instanceof String) {
                    String value = (String)object;
                    if (StringUtils.isEmpty((CharSequence)value)) {
                        Property property = this.getProperty();
                        if (!property.isRequired()) {
                            return null;
                        }
                        String msg = Messages.format((String)"property.error.required", (Object[])new Object[]{property.getDisplayName()});
                        throw new PropertyException(property, msg);
                    }
                    result = this.getDateTime(value);
                    break block8;
                }
                if (object instanceof Date) {
                    result = this.getDateTime((Date)object);
                    break block8;
                }
                if (object != null) throw this.getException(null);
                return null;
            }
            catch (ValidationException exception) {
                throw exception;
            }
            catch (Throwable exception) {
                throw this.getException(exception);
            }
        }
        if (result == null) return result;
        if (!this.keepSeconds) {
            result = this.removeSeconds(result);
        }
        this.checkDateRange(result, this.minDate, this.maxDate);
        return result;
    }

    public void setKeepSeconds(boolean keep) {
        this.keepSeconds = keep;
    }

    protected abstract Date getDateTime(String var1) throws ParseException;

    protected Date getDate() {
        return this.getProperty().getDate();
    }

    protected Date getDateTime(Date value) {
        return value;
    }

    protected Date addTime(String value) throws ParseException {
        Date time = this.parseTime(value);
        Date date = this.getDate();
        Date result = date != null ? DateRules.addDateTime((Date)date, (Date)time) : time;
        return result;
    }

    protected Date parseTime(String value) throws ParseException {
        return DateFormatter.parseTime((String)value);
    }

    protected void checkDateRange(Date date, Date min, Date max) {
        if (min != null && date.getTime() < min.getTime()) {
            String formatMin;
            String formatDate;
            if (this.format == Format.DATE) {
                formatDate = DateFormatter.formatDate((Date)date, (boolean)false);
                formatMin = DateFormatter.formatDate((Date)min, (boolean)false);
            } else {
                formatDate = DateFormatter.formatDateTime((Date)date);
                formatMin = DateFormatter.formatDateTime((Date)min);
            }
            String msg = Messages.format((String)"property.error.minDate", (Object[])new Object[]{formatDate, formatMin});
            throw new PropertyException(this.getProperty(), msg);
        }
        if (max != null && date.getTime() >= max.getTime()) {
            String formatMax;
            String formatDate;
            if (this.format == Format.DATE) {
                formatDate = DateFormatter.formatDate((Date)date, (boolean)false);
                formatMax = DateFormatter.formatDate((Date)max, (boolean)false);
            } else {
                formatDate = DateFormatter.formatDateTime((Date)date);
                formatMax = DateFormatter.formatDateTime((Date)max);
            }
            String msg = Messages.format((String)"property.error.maxDate", (Object[])new Object[]{formatDate, formatMax});
            throw new PropertyException(this.getProperty(), msg);
        }
    }

    protected PropertyException getException(Throwable cause) {
        String message = Messages.format((String)"property.error.invalidtime", (Object[])new Object[]{this.getProperty().getDisplayName()});
        return new PropertyException(this.getProperty(), message, cause);
    }

    private Date removeSeconds(Date date) {
        long ms = date.getTime();
        long seconds = ms % 60000L;
        if (seconds != 0L) {
            date = new Date(ms - seconds);
        }
        return date;
    }

    protected static enum Format {
        DATE,
        DATE_TIME;

    }
}

