/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.processor;

import org.openvpms.archetype.component.processor.BatchProcessor;
import org.openvpms.archetype.component.processor.BatchProcessorListener;
import org.openvpms.web.component.workflow.AbstractTask;
import org.openvpms.web.component.workflow.TaskContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BatchProcessorTask
extends AbstractTask {
    private final BatchProcessor processor;
    private boolean terminate = true;
    private static final Logger log = LoggerFactory.getLogger(BatchProcessorTask.class);

    public BatchProcessorTask(BatchProcessor processor) {
        this.processor = processor;
    }

    public BatchProcessor getProcessor() {
        return this.processor;
    }

    public void setTerminateOnError(boolean terminate) {
        this.terminate = terminate;
    }

    @Override
    public void start(TaskContext context) {
        this.processor.setListener(new BatchProcessorListener(){

            public void completed() {
                BatchProcessorTask.this.notifyCompleted();
            }

            public void error(Throwable exception) {
                if (BatchProcessorTask.this.terminate) {
                    BatchProcessorTask.this.notifyCancelledOnError(exception);
                } else {
                    log.error(exception.getMessage(), exception);
                }
            }
        });
        this.processor.process();
    }
}

