/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.print;

import java.util.Collections;
import java.util.List;
import org.openvpms.domain.practice.Location;
import org.openvpms.print.locator.DocumentPrinterServiceLocator;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.print.service.DocumentPrinterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtectedPrinterServiceLocator
implements DocumentPrinterServiceLocator {
    private final DocumentPrinterServiceLocator locator;
    private static final Logger log = LoggerFactory.getLogger(ProtectedPrinterServiceLocator.class);

    public ProtectedPrinterServiceLocator(DocumentPrinterServiceLocator locator) {
        this.locator = locator;
    }

    public DocumentPrinter getPrinter(String archetype, String id) {
        try {
            return this.locator.getPrinter(archetype, id);
        }
        catch (Throwable exception) {
            log.warn("Failed to retrieve printer for service=" + archetype + ", id=" + id + ": " + exception.getMessage(), exception);
            return null;
        }
    }

    public DocumentPrinter getDefaultPrinter() {
        try {
            return this.locator.getDefaultPrinter();
        }
        catch (Throwable exception) {
            log.warn("Failed to retrieve default printer: " + exception.getMessage(), exception);
            return null;
        }
    }

    public DocumentPrinter getDefaultPrinter(Location location) {
        try {
            return this.locator.getDefaultPrinter();
        }
        catch (Throwable exception) {
            log.warn("Failed to retrieve default printer for location=" + location.getName() + ": " + exception.getMessage(), exception);
            return null;
        }
    }

    public List<DocumentPrinter> getPrinters(Location location) {
        try {
            return this.locator.getPrinters(location);
        }
        catch (Throwable exception) {
            log.warn("Failed to retrieve printer for location=" + location.getName() + ": " + exception.getMessage(), exception);
            return Collections.emptyList();
        }
    }

    public List<DocumentPrinter> getPrinters() {
        try {
            return this.locator.getPrinters();
        }
        catch (Throwable exception) {
            log.warn("Failed to retrieve printers: " + exception.getMessage(), exception);
            return Collections.emptyList();
        }
    }

    public List<DocumentPrinterService> getServices() {
        try {
            return this.locator.getServices();
        }
        catch (Throwable exception) {
            log.warn("Failed to retrieve printer services: " + exception.getMessage(), exception);
            return Collections.emptyList();
        }
    }

    public DocumentPrinterService getJavaPrintService() {
        return this.locator.getJavaPrintService();
    }
}

