/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.print;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import nextapp.echo2.app.Column;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.SelectField;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.archetype.rules.practice.LocationRules;
import org.openvpms.component.model.party.Party;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.web.component.bound.SpinBox;
import org.openvpms.web.component.print.PrintHelper;
import org.openvpms.web.component.print.PrinterField;
import org.openvpms.web.component.print.PrinterListModel;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.system.ServiceHelper;

public class PrintDialog
extends PopupDialog {
    protected static final String PREVIEW_ID = "button.preview";
    protected static final String MAIL_ID = "button.mail";
    private final SelectField printers;
    private final boolean preview;
    private final boolean mail;
    private final SpinBox copies;

    public PrintDialog(String title, boolean preview, boolean mail, boolean skip, Party location, HelpContext help) {
        super(title, "PrintDialog", skip ? OK_SKIP_CANCEL : OK_CANCEL, help);
        this.setModal(true);
        this.copies = new SpinBox(1, 99);
        this.printers = new PrinterField(this.getPrinters(location));
        this.preview = preview;
        this.mail = mail;
        FocusGroup parent = this.getFocusGroup();
        FocusGroup child = new FocusGroup("PrintDialog");
        child.add((Component)this.printers);
        child.add(this.copies.getFocusGroup());
        parent.add(0, child);
    }

    public void setDefaultPrinter(DocumentPrinter printer) {
        PrinterReference reference;
        PrinterListModel model = (PrinterListModel)this.printers.getModel();
        int index = model.indexOf(reference = printer != null ? new PrinterReference(printer.getArchetype(), printer.getId()) : null);
        if (index != -1) {
            this.printers.setSelectedIndex(index);
        }
    }

    public PrinterReference getPrinter() {
        return (PrinterReference)this.printers.getSelectedItem();
    }

    public void setCopies(int copies) {
        this.copies.setValue(copies);
    }

    public int getCopies() {
        return this.copies.getValue();
    }

    protected void doLayout() {
        Column column = ColumnFactory.create((String)"WideCellSpacing");
        this.doLayout((Component)column);
        this.getLayout().add((Component)ColumnFactory.create((String)"Inset", (Component[])new Component[]{column}));
    }

    protected void doLayout(Component container) {
        if (this.preview) {
            this.addButton(PREVIEW_ID, this::onPreview);
        }
        if (this.mail) {
            this.addButton(MAIL_ID, this::onMail);
        }
        Grid grid = GridFactory.create((int)2);
        grid.add((Component)LabelFactory.create((String)"printdialog.printer"));
        grid.add((Component)this.printers);
        grid.add((Component)LabelFactory.create((String)"printdialog.copies"));
        grid.add((Component)this.copies);
        this.setFocus((Component)this.copies);
        container.add((Component)grid);
    }

    protected void onPreview() {
    }

    protected void onMail() {
    }

    protected List<PrinterReference> getPrinters(Party location) {
        List<PrinterReference> result;
        List<PrinterReference> available = PrintHelper.getPrinters();
        if (location != null) {
            LocationRules rules = ServiceHelper.getBean(LocationRules.class);
            HashSet<PrinterReference> locationSet = new HashSet<PrinterReference>(rules.getPrinters(location));
            if (!locationSet.isEmpty()) {
                HashSet<PrinterReference> set = new HashSet<PrinterReference>(available);
                PrinterReference defaultPrinter = rules.getDefaultPrinter(location);
                if (defaultPrinter != null) {
                    locationSet = new HashSet(locationSet);
                    locationSet.add(defaultPrinter);
                }
                set.retainAll(locationSet);
                result = new ArrayList<PrinterReference>(set);
            } else {
                result = available;
            }
        } else {
            result = available;
        }
        return result;
    }
}

