/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.print;

import org.openvpms.component.model.document.Document;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.job.JobBuilder;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.print.ExportPrintDialog;
import org.openvpms.web.component.print.InteractivePrinter;
import org.openvpms.web.component.print.PrintDialog;
import org.openvpms.web.component.print.Printer;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.servlet.DownloadServlet;
import org.openvpms.web.resource.i18n.Messages;

public class InteractiveExportPrinter
extends InteractivePrinter {
    public InteractiveExportPrinter(Printer printer, Context context, MailContext mailContext, HelpContext help) {
        this(null, printer, context, mailContext, help);
    }

    public InteractiveExportPrinter(String title, Printer printer, Context context, MailContext mailContext, HelpContext help) {
        this(title, printer, false, context, mailContext, help);
    }

    public InteractiveExportPrinter(String title, Printer printer, boolean skip, Context context, MailContext mailContext, HelpContext help) {
        super(title, printer, skip, context, help);
        this.setMailContext(mailContext);
    }

    @Override
    protected PrintDialog createDialog() {
        return new ExportPrintDialog(this.getTitle(), this.getContext().getLocation(), this.getHelpContext()){

            @Override
            protected void onPreview() {
                InteractiveExportPrinter.this.preview();
            }

            @Override
            protected void onMail() {
                InteractiveExportPrinter.this.mail(this);
            }

            @Override
            protected void onExport() {
                InteractiveExportPrinter.this.export();
            }

            @Override
            protected void onExportMail() {
                InteractiveExportPrinter.this.exportMail(this);
            }
        };
    }

    protected void export() {
        Job<Document> job = JobBuilder.newJob(this.getDisplayName(), this.getContext().getUser()).get(() -> this.getDocument("text/csv", false)).completed(DownloadServlet::startDownload).failed(this::failed).build();
        this.getJobManager().runInteractive(job, Messages.get((String)"document.export.title"), Messages.get((String)"document.export.cancel"));
    }

    protected void exportMail(PrintDialog parent) {
        Job<Document> job = JobBuilder.newJob(this.getDisplayName(), this.getContext().getUser()).get(() -> this.getDocument("text/csv", false)).completed(document -> this.mail((Document)document, parent)).failed(this::failed).build();
        this.getJobManager().runInteractive(job, Messages.get((String)"document.export.title"), Messages.get((String)"document.export.cancel"));
    }
}

