/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.print;

import java.util.Objects;
import org.openvpms.archetype.rules.doc.DocumentTemplate;
import org.openvpms.archetype.rules.doc.DocumentTemplatePrinter;
import org.openvpms.archetype.rules.doc.PrinterReference;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Party;
import org.openvpms.print.exception.PrinterException;
import org.openvpms.print.impl.exception.PrintNotSupported;
import org.openvpms.print.impl.i18n.PrintMessages;
import org.openvpms.print.locator.DocumentPrinterServiceLocator;
import org.openvpms.print.service.DocumentPrinter;
import org.openvpms.print.service.PrintAttributes;
import org.openvpms.report.DocumentConverter;
import org.openvpms.report.PrintProperties;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.im.print.PrinterContext;
import org.openvpms.web.component.print.Printer;

public abstract class AbstractPrinter
implements Printer {
    private final PrinterContext printerContext;
    private final Context context;
    private boolean interactive = true;
    private int copies;

    public AbstractPrinter(PrinterContext printerContext, Context context) {
        this.printerContext = printerContext;
        this.context = context;
    }

    @Override
    public void print() {
        this.print((PrinterReference)null);
    }

    @Override
    public void print(PrinterReference reference) {
        DocumentPrinter printer = reference != null ? this.printerContext.getPrinter(reference) : this.getDefaultPrinter();
        this.print(printer);
    }

    @Override
    public DocumentPrinter getDefaultPrinter() {
        return this.getDefaultLocationPrinter();
    }

    @Override
    public boolean getInteractive() {
        return this.interactive;
    }

    @Override
    public void setCopies(int copies) {
        this.copies = copies;
    }

    @Override
    public int getCopies() {
        return this.copies;
    }

    @Override
    public DocumentPrinterServiceLocator getPrinterLocator() {
        return this.printerContext.getPrinterLocator();
    }

    protected PrinterContext getPrinterContext() {
        return this.printerContext;
    }

    protected PrintProperties getProperties(DocumentPrinter printer) {
        PrintProperties result = new PrintProperties(printer.getId());
        result.setCopies(this.getCopies());
        return result;
    }

    protected PrintProperties getProperties(DocumentPrinter printer, DocumentTemplate template) {
        PrintProperties properties = new PrintProperties(printer.getId());
        properties.setCopies(this.getCopies());
        if (template != null) {
            properties.setMediaSize(template.getMediaSize());
            properties.setOrientation(template.getOrientationRequested());
            DocumentTemplatePrinter relationship = this.getDocumentTemplatePrinter(template, printer);
            if (relationship != null) {
                properties.setMediaTray(relationship.getMediaTray());
                properties.setSides(relationship.getSides());
            }
        }
        return properties;
    }

    protected void print(Document document, DocumentPrinter printer) {
        if (printer == null) {
            throw new PrinterException(PrintMessages.noPrinter());
        }
        DocumentConverter converter = this.getConverter();
        if (printer.canPrint(document.getMimeType())) {
            printer.print(this.getDecompressed(document), (PrintAttributes)this.getProperties(printer));
        } else if (printer.canPrint("application/pdf") && converter.canConvert(document, "application/pdf")) {
            Document pdf = converter.convert(document, "application/pdf");
            printer.print(this.getDecompressed(pdf), (PrintAttributes)this.getProperties(printer));
        } else {
            throw new PrintNotSupported(PrintMessages.unsupportedDocument((String)document.getName(), (String)printer.getName()));
        }
    }

    protected void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    protected DocumentPrinter getDefaultPrinter(DocumentTemplate template) {
        PrinterReference reference;
        DocumentTemplatePrinter printer;
        DocumentPrinter result = null;
        DocumentTemplatePrinter documentTemplatePrinter = printer = template != null ? this.getDocumentTemplatePrinter(template) : null;
        if (printer != null && (reference = printer.getPrinter()) != null) {
            result = this.printerContext.getPrinter(reference);
        }
        if (result == null) {
            result = this.getDefaultLocationPrinter();
        }
        return result;
    }

    protected DocumentPrinter getDefaultLocationPrinter() {
        DocumentPrinter result = null;
        Party location = this.context.getLocation();
        if (location != null) {
            result = this.printerContext.getDefaultPrinter(location);
        }
        if (result == null) {
            result = this.printerContext.getDefaultPrinter();
        }
        return result;
    }

    protected DocumentTemplatePrinter getDocumentTemplatePrinter(DocumentTemplate template, DocumentPrinter printer) {
        PrinterReference reference;
        DocumentTemplatePrinter relationship = this.getDocumentTemplatePrinter(template);
        if (relationship != null && Objects.equals(reference = new PrinterReference(printer.getArchetype(), printer.getId()), relationship.getPrinter())) {
            return relationship;
        }
        return null;
    }

    protected DocumentTemplatePrinter getDocumentTemplatePrinter(DocumentTemplate template) {
        DocumentTemplatePrinter printer = null;
        Party location = this.context.getLocation();
        Party practice = this.context.getPractice();
        if (location != null) {
            printer = template.getPrinter((Entity)location);
        }
        if (printer == null && practice != null) {
            printer = template.getPrinter((Entity)practice);
        }
        return printer;
    }

    protected boolean getInteractive(DocumentTemplate template, DocumentPrinter printer) {
        DocumentTemplatePrinter relationship = this.getDocumentTemplatePrinter(template, printer);
        return relationship == null || relationship.getInteractive();
    }

    protected Document getDocument(Reference reference) {
        return reference != null ? (Document)this.getService().get(reference) : null;
    }

    protected IArchetypeService getService() {
        return this.printerContext.getService();
    }

    protected DocumentConverter getConverter() {
        return this.printerContext.getConverter();
    }

    protected Context getContext() {
        return this.context;
    }

    private Document getDecompressed(Document document) {
        PrinterContext context = this.getPrinterContext();
        return context.getDecompressedDocument(document);
    }
}

