/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.util.List;
import nextapp.echo2.app.Alignment;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.Extent;
import nextapp.echo2.app.Grid;
import nextapp.echo2.app.Label;
import nextapp.echo2.app.LayoutData;
import nextapp.echo2.app.layout.GridLayoutData;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.Macros;
import org.openvpms.web.component.bound.BoundTextComponentFactory;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.mail.FromAddressSelector;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailHelper;
import org.openvpms.web.component.mail.ToAddressSelector;
import org.openvpms.web.component.property.AbstractModifiable;
import org.openvpms.web.component.property.ErrorListener;
import org.openvpms.web.component.property.Modifiable;
import org.openvpms.web.component.property.ModifiableListener;
import org.openvpms.web.component.property.ModifiableListeners;
import org.openvpms.web.component.property.SimpleProperty;
import org.openvpms.web.component.property.Validator;
import org.openvpms.web.component.property.ValidatorError;
import org.openvpms.web.echo.factory.ColumnFactory;
import org.openvpms.web.echo.factory.GridFactory;
import org.openvpms.web.echo.factory.LabelFactory;
import org.openvpms.web.echo.focus.FocusGroup;
import org.openvpms.web.echo.style.Styles;
import org.openvpms.web.echo.text.TextField;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class MailHeader
extends AbstractModifiable {
    private final MailContext mailContext;
    private final FocusGroup focus;
    private final ModifiableListeners listeners = new ModifiableListeners();
    private final ToAddressSelector to;
    private final ToAddressSelector cc;
    private final ToAddressSelector bcc;
    private final SimpleProperty subject;
    private final FromAddressSelector from;
    private Component component;

    public MailHeader(MailContext mailContext, Contact preferredTo, LayoutContext context) {
        this.mailContext = mailContext;
        List<Contact> fromAddresses = mailContext.getFromAddresses();
        this.focus = new FocusGroup("MailHeader");
        this.from = new FromAddressSelector(fromAddresses, mailContext.getFromAddressFormatter());
        if (!fromAddresses.isEmpty()) {
            this.from.setSelected(fromAddresses.get(0));
            if (fromAddresses.size() > 1) {
                this.focus.add(this.from.getComponent());
            }
        }
        MailContext.Addresses addresses = mailContext.getToAddresses();
        List<Contact> contacts = addresses.getContacts();
        this.to = new ToAddressSelector(contacts, mailContext.getToAddressFormatter(), context, "mail.to");
        this.cc = new ToAddressSelector(contacts, mailContext.getToAddressFormatter(), context, "mail.cc");
        this.bcc = new ToAddressSelector(contacts, mailContext.getToAddressFormatter(), context, "mail.bcc");
        if (preferredTo == null) {
            preferredTo = addresses.getPreferred();
        }
        if (preferredTo != null) {
            this.setTo(preferredTo);
        }
        Variables variables = mailContext.getVariables();
        Macros macros = ServiceHelper.getMacros();
        this.subject = MailHelper.createProperty("subject", "mail.subject", true, macros, variables);
        ModifiableListener listener = modifiable -> this.listeners.notifyListeners(this);
        this.from.addModifiableListener(listener);
        this.to.addModifiableListener(listener);
        this.cc.addModifiableListener(listener);
        this.bcc.addModifiableListener(listener);
        this.subject.addModifiableListener(listener);
    }

    public MailContext getMailContext() {
        return this.mailContext;
    }

    public FocusGroup getFocusGroup() {
        return this.focus;
    }

    public Component getComponent() {
        if (this.component == null) {
            Grid grid = this.createHeader();
            this.component = ColumnFactory.create((String)"Inset.Large", (Component[])new Component[]{grid});
        }
        return this.component;
    }

    public void setFrom(Contact from) {
        this.from.setSelected(from);
    }

    public String getFrom() {
        return this.from.getNameAddress();
    }

    public void addTo(Contact contact) {
        this.to.addContact(contact);
    }

    public void setTo(Contact contact) {
        this.to.setSelected(contact);
    }

    public String[] getTo() {
        return this.to.getAddresses();
    }

    public String[] getCc() {
        return this.cc.getAddresses();
    }

    public String[] getBcc() {
        return this.bcc.getAddresses();
    }

    public void setSubject(String subject) {
        this.subject.setValue(subject);
    }

    public String getSubject() {
        return (String)this.subject.getValue();
    }

    @Override
    public boolean isModified() {
        return this.from.isModified() || this.to.isModified() || this.cc.isModified() || this.bcc.isModified() || this.subject.isModified();
    }

    @Override
    public void clearModified() {
        this.from.clearModified();
        this.to.clearModified();
        this.cc.clearModified();
        this.bcc.clearModified();
        this.subject.clearModified();
    }

    @Override
    public void addModifiableListener(ModifiableListener listener) {
        this.listeners.addListener(listener);
    }

    @Override
    public void addModifiableListener(ModifiableListener listener, int index) {
        this.listeners.addListener(listener, index);
    }

    @Override
    public void removeModifiableListener(ModifiableListener listener) {
        this.listeners.removeListener(listener);
    }

    @Override
    public void setErrorListener(ErrorListener listener) {
    }

    @Override
    public ErrorListener getErrorListener() {
        return null;
    }

    protected Grid createHeader() {
        TextField subjectText = BoundTextComponentFactory.create(this.subject, 40);
        subjectText.setWidth(Styles.FULL_WIDTH);
        Grid grid = GridFactory.create((int)2, (Component[])new Component[]{this.createLabel("mail.from"), this.from.getComponent(), this.createLabel("mail.to"), this.to.getComponent(), this.createLabel("mail.cc"), this.cc.getComponent(), this.createLabel("mail.bcc"), this.bcc.getComponent(), this.createLabel("mail.subject"), subjectText});
        grid.setColumnWidth(0, new Extent(10, 2));
        grid.setWidth(Styles.FULL_WIDTH);
        this.focus.add((Component)this.to.getField());
        this.focus.add((Component)this.cc.getField());
        this.focus.add((Component)this.bcc.getField());
        this.focus.add((Component)subjectText);
        if (this.to.getSelected() == null) {
            this.focus.setDefault((Component)this.to.getField());
        } else {
            this.focus.setDefault((Component)subjectText);
        }
        return grid;
    }

    @Override
    protected boolean doValidation(Validator validator) {
        boolean valid;
        boolean bl = valid = validator.validate(this.from) && validator.validate(this.to) && validator.validate(this.cc) && validator.validate(this.bcc) && validator.validate(this.subject);
        if (valid && this.getTo() == null && this.getCc() == null && this.getBcc() == null) {
            validator.add((Modifiable)this, new ValidatorError(Messages.get((String)"mail.notoaddress")));
            valid = false;
        }
        return valid;
    }

    private Label createLabel(String key) {
        Label label = LabelFactory.create((String)key);
        GridLayoutData layout = new GridLayoutData();
        layout.setAlignment(Alignment.ALIGN_RIGHT);
        label.setLayoutData((LayoutData)layout);
        return label;
    }
}

