/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import echopointng.KeyStrokeListener;
import java.util.Collection;
import java.util.Iterator;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.event.ActionEvent;
import nextapp.echo2.app.event.WindowPaneEvent;
import nextapp.echo2.app.event.WindowPaneListener;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.EmailTemplate;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.party.Contact;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.doc.DocumentUploadListener;
import org.openvpms.web.component.im.doc.UploadDialog;
import org.openvpms.web.component.im.layout.LayoutContext;
import org.openvpms.web.component.im.query.Browser;
import org.openvpms.web.component.im.query.BrowserDialog;
import org.openvpms.web.component.im.query.BrowserFactory;
import org.openvpms.web.component.im.query.Query;
import org.openvpms.web.component.im.query.QueryFactory;
import org.openvpms.web.component.macro.MacroDialog;
import org.openvpms.web.component.mail.AttachmentBrowser;
import org.openvpms.web.component.mail.AttachmentDialog;
import org.openvpms.web.component.mail.AttachmentGenerator;
import org.openvpms.web.component.mail.AttachmentGeneratorFactory;
import org.openvpms.web.component.mail.MailAttachment;
import org.openvpms.web.component.mail.MailContext;
import org.openvpms.web.component.mail.MailEditor;
import org.openvpms.web.component.mail.Mailer;
import org.openvpms.web.component.mail.MailerFactory;
import org.openvpms.web.component.property.DefaultValidator;
import org.openvpms.web.component.property.ValidationHelper;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.button.ShortcutButtons;
import org.openvpms.web.echo.dialog.ConfirmationDialog;
import org.openvpms.web.echo.dialog.ModalDialog;
import org.openvpms.web.echo.dialog.PopupDialogListener;
import org.openvpms.web.echo.event.ActionListener;
import org.openvpms.web.echo.event.Vetoable;
import org.openvpms.web.echo.factory.SplitPaneFactory;
import org.openvpms.web.echo.focus.FocusCommand;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public class MailDialog
extends ModalDialog {
    public static final String SEND_ID = "send";
    private final MailEditor editor;
    private final AttachmentBrowser attachments;
    private final LayoutContext context;
    private final ArchetypeService service;
    private static final String EDIT_ID = "button.edit";
    private static final String TEMPLATE_ID = "button.template";
    private static final String DONT_SEND_ID = "button.dontSend";
    private static final String ATTACH_ID = "button.attach";
    private static final String ATTACH_FILE_ID = "button.attachFile";
    private static final String[] NEW_SEND_ATTACH_ALL_CANCEL = new String[]{"send", "button.template", "button.attach", "button.attachFile", "cancel"};
    private static final String[] NEW_SEND_ATTACH_FILE_CANCEL = new String[]{"send", "button.template", "button.attachFile", "cancel"};
    private static final String[] EDIT_DONT_SEND = new String[]{"button.edit", "button.dontSend"};

    public MailDialog(MailContext mailContext, Contact preferred, LayoutContext context) {
        this(mailContext, preferred, mailContext.createAttachmentBrowser(), context);
    }

    public MailDialog(MailContext mailContext, Contact preferred, AttachmentBrowser attachments, LayoutContext context) {
        this(Messages.get((String)"mail.title"), mailContext, preferred, attachments, context);
    }

    public MailDialog(String title, MailContext mailContext, Contact preferred, AttachmentBrowser attachments, LayoutContext context) {
        this(title, new MailEditor(mailContext, preferred, context), attachments, context);
    }

    public MailDialog(MailEditor editor, AttachmentBrowser attachments, LayoutContext context) {
        this(Messages.get((String)"mail.title"), editor, attachments, context);
    }

    public MailDialog(String title, MailEditor editor, AttachmentBrowser attachments, LayoutContext context) {
        super(title, "MailDialog", attachments != null ? NEW_SEND_ATTACH_ALL_CANCEL : NEW_SEND_ATTACH_FILE_CANCEL, context.getHelpContext());
        this.setDefaultCloseAction("cancel");
        this.attachments = attachments;
        this.context = context;
        this.editor = editor;
        this.service = ServiceHelper.getArchetypeService();
        this.getLayout().add(editor.getComponent());
        this.getFocusGroup().add(editor.getFocusGroup());
        this.setCancelListener(this::onCancel);
        ButtonSet buttons = this.getButtons();
        buttons.addKeyListener(4173, (nextapp.echo2.app.event.ActionListener)new ActionListener(){

            public void onAction(ActionEvent event) {
                MailDialog.this.onMacro();
            }
        });
        this.registerShortcuts();
        editor.getFocusGroup().setFocus();
    }

    public MailEditor getMailEditor() {
        return this.editor;
    }

    protected void onClosing() {
        try {
            this.editor.dispose();
        }
        catch (Throwable exception) {
            ErrorHelper.show(exception);
        }
    }

    protected SplitPane createSplitPane() {
        return SplitPaneFactory.create((int)5, (String)"PopupWindow.Layout", (Component[])new Component[0]);
    }

    protected void onButton(String button) {
        if (TEMPLATE_ID.equals(button)) {
            this.newFromTemplate();
        } else if (ATTACH_ID.equals(button)) {
            this.attach();
        } else if (ATTACH_FILE_ID.equals(button)) {
            this.attachFile();
        } else if (SEND_ID.equals(button)) {
            if (this.send()) {
                this.close(SEND_ID);
            }
        } else {
            super.onButton(button);
        }
    }

    protected void registerShortcuts() {
        final ShortcutButtons buttons = this.getButtons().getButtons();
        KeyStrokeListener listener = this.editor.getKeyStrokeListener();
        KeyStrokeListener shortcutListener = buttons.getKeyStrokeListener();
        int[] keys = shortcutListener.getKeyCombinations();
        if (keys.length > 0) {
            for (int key : keys) {
                String command = shortcutListener.getKeyCombinationCommand(key);
                if (command != null) {
                    listener.addKeyCombination(key, command);
                    continue;
                }
                listener.addKeyCombination(key);
            }
            listener.addActionListener((nextapp.echo2.app.event.ActionListener)new ActionListener(){

                public void onAction(ActionEvent event) {
                    buttons.processInput(event);
                }
            });
        }
    }

    protected Mailer createMailer(MailEditor editor) {
        return ServiceHelper.getBean(MailerFactory.class).create(editor.getMailContext());
    }

    protected void send(Mailer mailer) {
        mailer.send();
    }

    protected void populate(Mailer mailer, MailEditor editor) {
        mailer.setFrom(editor.getFrom());
        mailer.setTo(editor.getTo());
        mailer.setCc(editor.getCc());
        mailer.setBcc(editor.getBcc());
        mailer.setSubject(editor.getSubject());
        mailer.setBody(editor.getMessage());
        for (Reference attachment : editor.getAttachments()) {
            Document document = (Document)this.service.get(attachment, Document.class);
            if (document == null) continue;
            mailer.addAttachment(document);
        }
    }

    private void newFromTemplate() {
        if (!StringUtils.isBlank((CharSequence)this.editor.getMessage())) {
            ConfirmationDialog.show((String)Messages.get((String)"mail.replace.title"), (String)Messages.get((String)"mail.replace.message"), (String[])ConfirmationDialog.YES_NO, (WindowPaneListener)new PopupDialogListener(){

                public void onYes() {
                    MailDialog.this.onTemplate();
                }
            });
        } else {
            this.onTemplate();
        }
    }

    private void onTemplate() {
        Query query = QueryFactory.create("entity.documentTemplateEmailUser", this.context.getContext());
        Browser browser = BrowserFactory.create(query, this.context);
        String title = Messages.format((String)"imobject.select.title", (Object[])new Object[]{DescriptorHelper.getDisplayName((String)"entity.documentTemplateEmailUser", (ArchetypeService)this.service)});
        final BrowserDialog dialog = new BrowserDialog(title, browser, this.getHelpContext().subtopic("template"));
        dialog.addWindowPaneListener((WindowPaneListener)new PopupDialogListener(){

            public void onOK() {
                Entity selected = (Entity)dialog.getSelected();
                if (selected != null) {
                    MailDialog.this.editor.setContent(new EmailTemplate(selected, MailDialog.this.service), true);
                }
            }
        });
        dialog.show();
    }

    private void attach() {
        final FocusCommand focus = new FocusCommand();
        HelpContext help = this.getHelpContext().subtopic("attach");
        final AttachmentDialog dialog = new AttachmentDialog(this.attachments, help);
        dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

            public void onClose(WindowPaneEvent event) {
                focus.restore();
                if ("ok".equals(dialog.getAction())) {
                    MailDialog.this.attach(MailDialog.this.attachments.getSelections());
                }
                MailDialog.this.attachments.clearSelections();
            }
        });
        dialog.show();
    }

    private void attach(Collection<MailAttachment> documents) {
        AttachmentGeneratorFactory factory = ServiceHelper.getBean(AttachmentGeneratorFactory.class);
        AttachmentGenerator generator = factory.create(this.context.getContext(), this.getHelpContext());
        this.attach(documents.iterator(), generator);
    }

    private void attach(Iterator<MailAttachment> iterator, AttachmentGenerator generator) {
        if (iterator.hasNext()) {
            generator.generate(iterator.next(), result -> {
                if (result.getDocument() != null) {
                    try {
                        this.editor.addAttachment(result.getDocument());
                        this.attach(iterator, generator);
                    }
                    catch (Exception exception) {
                        this.attachError(AttachmentGenerator.Result.error(exception));
                    }
                } else {
                    this.attachError((AttachmentGenerator.Result)result);
                }
            });
        }
    }

    private void attachError(AttachmentGenerator.Result result) {
        if (result.getCause() != null) {
            ErrorHelper.show(Messages.get((String)"mail.attach.error"), result.getCause());
        } else {
            ErrorHelper.show(Messages.get((String)"mail.attach.error"), result.getError());
        }
    }

    private void attachFile() {
        final FocusCommand focus = new FocusCommand();
        DocumentUploadListener listener = new DocumentUploadListener(){

            @Override
            protected void upload(Document document) {
                focus.restore();
                MailDialog.this.editor.addAttachment(document);
            }
        };
        UploadDialog dialog = new UploadDialog(listener, this.getHelpContext().subtopic("attachFile"));
        dialog.show();
    }

    private boolean send() {
        boolean result = false;
        try {
            DefaultValidator validator = new DefaultValidator();
            if (this.editor.validate(validator)) {
                Mailer mailer = this.createMailer(this.editor);
                this.populate(mailer, this.editor);
                this.send(mailer);
                result = true;
            } else {
                ValidationHelper.showError(Messages.get((String)"mail.error.title"), validator, "mail.error.message", false);
            }
        }
        catch (Throwable exception) {
            ErrorHelper.show(exception);
        }
        return result;
    }

    private void onCancel(final Vetoable action) {
        if (!this.editor.getAttachments().isEmpty() || !StringUtils.isEmpty((CharSequence)this.editor.getMessage())) {
            final ConfirmationDialog dialog = new ConfirmationDialog(Messages.get((String)"mail.cancel.title"), Messages.get((String)"mail.cancel.message"), EDIT_DONT_SEND);
            dialog.addWindowPaneListener((WindowPaneListener)new org.openvpms.web.echo.event.WindowPaneListener(){

                public void onClose(WindowPaneEvent e) {
                    action.veto(MailDialog.EDIT_ID.equals(dialog.getAction()));
                }
            });
            dialog.show();
        } else {
            action.veto(false);
        }
    }

    private void onMacro() {
        MacroDialog dialog = new MacroDialog(this.context.getContext(), this.getHelpContext());
        dialog.show();
    }
}

