/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import java.io.IOException;
import java.io.StringReader;
import java.util.Enumeration;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.parser.ParserDelegator;
import org.apache.commons.lang.StringEscapeUtils;

public class HtmlFilter {
    public static String filter(String html) {
        String result;
        ParserDelegator delegator = new ParserDelegator();
        try {
            StringBuilder buffer = new StringBuilder();
            delegator.parse(new StringReader(html), new Filter(buffer), true);
            result = buffer.toString();
        }
        catch (IOException exception) {
            result = null;
        }
        return result;
    }

    private static class Filter
    extends HTMLEditorKit.ParserCallback {
        private final StringBuilder buffer;
        private int skip;

        public Filter(StringBuilder buffer) {
            this.buffer = buffer;
        }

        @Override
        public void handleStartTag(HTML.Tag tag, MutableAttributeSet set, int pos) {
            if (this.skip == 0 && !this.exclude(tag)) {
                if (this.emit(tag)) {
                    this.buffer.append('<').append(tag.toString());
                    this.append(set);
                    this.buffer.append('>');
                }
            } else {
                ++this.skip;
            }
        }

        @Override
        public void handleText(char[] data, int pos) {
            if (this.skip == 0) {
                this.buffer.append(StringEscapeUtils.escapeHtml((String)new String(data)));
            }
        }

        @Override
        public void handleEndTag(HTML.Tag tag, int pos) {
            if (!this.exclude(tag)) {
                if (this.emit(tag)) {
                    this.buffer.append("</").append(tag.toString()).append(">");
                }
            } else {
                --this.skip;
            }
        }

        @Override
        public void handleSimpleTag(HTML.Tag tag, MutableAttributeSet set, int pos) {
            if (this.skip == 0 && !this.exclude(tag) && this.emit(tag)) {
                this.buffer.append("<").append(tag.toString());
                this.append(set);
                this.buffer.append("/>");
            }
        }

        protected boolean exclude(HTML.Tag tag) {
            return tag == HTML.Tag.HEAD || tag == HTML.Tag.META || tag == HTML.Tag.STYLE || tag == HTML.Tag.TITLE || tag == HTML.Tag.SCRIPT;
        }

        protected boolean emit(HTML.Tag tag) {
            return tag != HTML.Tag.HTML && tag != HTML.Tag.BODY;
        }

        private void append(MutableAttributeSet set) {
            Enumeration<?> names = set.getAttributeNames();
            if (names.hasMoreElements()) {
                this.buffer.append(' ');
                boolean first = true;
                while (names.hasMoreElements()) {
                    if (!first) {
                        this.buffer.append(' ');
                    } else {
                        first = false;
                    }
                    Object element = names.nextElement();
                    this.buffer.append(element).append("=\"").append(set.getAttribute(element)).append('\"');
                }
            }
        }
    }
}

