/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.mail;

import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.party.Contact;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.contact.ContactHelper;
import org.openvpms.web.component.mail.AddressFormatter;
import org.openvpms.web.component.mail.EmailAddress;
import org.openvpms.web.resource.i18n.Messages;
import org.openvpms.web.system.ServiceHelper;

public abstract class AbstractAddressFormatter
implements AddressFormatter {
    private final ArchetypeService service = ServiceHelper.getArchetypeService();
    private final String defaultValue = ContactHelper.getDefaultEmailName(this.service);

    @Override
    public String getAddress(org.openvpms.component.model.party.Contact contact) {
        return contact != null ? ContactHelper.getEmail(contact, this.service) : null;
    }

    @Override
    public String getName(org.openvpms.component.model.party.Contact contact) {
        String name = this.getContactName(contact);
        if (name == null || StringUtils.equals((CharSequence)this.defaultValue, (CharSequence)name)) {
            name = this.getPartyName(contact);
        }
        return name;
    }

    @Override
    public String getQualifiedName(org.openvpms.component.model.party.Contact contact) {
        String name = this.getContactName(contact);
        String partyName = this.getPartyName(contact);
        name = name == null || StringUtils.equals((CharSequence)this.defaultValue, (CharSequence)name) ? partyName : (partyName != null ? Messages.format((String)"mail.qualifiedname", (Object[])new Object[]{name, partyName}) : name);
        return name;
    }

    @Override
    public String getNameAddress(org.openvpms.component.model.party.Contact contact, boolean strict) {
        String name = this.getName(contact);
        return this.getNameAddress(contact, name, strict);
    }

    @Override
    public String getQualifiedNameAddress(org.openvpms.component.model.party.Contact contact) {
        String name = this.getQualifiedName(contact);
        return this.getNameAddress(contact, name, false);
    }

    @Override
    public String getType(org.openvpms.component.model.party.Contact contact) {
        Party party = this.getParty(contact);
        return party != null ? DescriptorHelper.getDisplayName((IMObject)party, (ArchetypeService)this.service) : null;
    }

    private String getContactName(org.openvpms.component.model.party.Contact contact) {
        return StringUtils.trimToNull((String)contact.getName());
    }

    private String getPartyName(org.openvpms.component.model.party.Contact contact) {
        Party party = this.getParty(contact);
        return party != null ? StringUtils.trimToNull((String)party.getName()) : null;
    }

    private Party getParty(org.openvpms.component.model.party.Contact contact) {
        return ((Contact)contact).getParty();
    }

    private String getNameAddress(org.openvpms.component.model.party.Contact contact, String name, boolean strict) {
        String address = this.getAddress(contact);
        return new EmailAddress(address, name).toString(strict);
    }
}

