/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.job;

import java.util.function.Consumer;
import java.util.function.Supplier;
import org.openvpms.component.model.user.User;
import org.openvpms.web.component.job.AbstractJob;
import org.openvpms.web.component.job.Job;
import org.openvpms.web.component.util.ErrorHelper;

public class JobBuilder<T> {
    private final String name;
    private final User user;
    private Supplier<T> command;
    private Consumer<T> completed;
    private Runnable cancelled;
    private Consumer<Throwable> failed;

    public JobBuilder(String name, User user) {
        this.name = name;
        this.user = user;
        this.failed = ErrorHelper::show;
    }

    public JobBuilder<T> run(Runnable command) {
        return this.get(() -> {
            command.run();
            return null;
        });
    }

    public JobBuilder<T> get(Supplier<T> command) {
        this.command = command;
        return this;
    }

    public JobBuilder<T> completed(Consumer<T> listener) {
        this.completed = listener;
        return this;
    }

    public JobBuilder<T> completed(Runnable listener) {
        return this.completed((T value) -> listener.run());
    }

    public JobBuilder<T> cancelled(Runnable listener) {
        this.cancelled = listener;
        return this;
    }

    public JobBuilder<T> failed(Consumer<Throwable> listener) {
        this.failed = listener;
        return this;
    }

    public Job<T> build() {
        return new DefaultJob<T>(this.name, this.user, this.command, this.completed, this.cancelled, this.failed);
    }

    public static <T> JobBuilder<T> newJob(String name, User user) {
        return new JobBuilder<T>(name, user);
    }

    static class DefaultJob<T>
    extends AbstractJob<T> {
        private final Supplier<T> command;
        private final Consumer<T> completionListener;
        private final Runnable cancellationListener;
        private final Consumer<Throwable> failureListener;

        public DefaultJob(String name, User user, Supplier<T> command, Consumer<T> completionListener, Runnable cancellationListener, Consumer<Throwable> failureListener) {
            super(name, user);
            this.command = command;
            this.completionListener = completionListener;
            this.cancellationListener = cancellationListener;
            this.failureListener = failureListener;
        }

        @Override
        public Consumer<T> getCompletionListener() {
            return this.completionListener;
        }

        @Override
        public Runnable getCancellationListener() {
            return this.cancellationListener;
        }

        @Override
        public Consumer<Throwable> getFailureListener() {
            return this.failureListener;
        }

        @Override
        protected T runJob() {
            return this.command != null ? (T)this.command.get() : null;
        }
    }
}

