/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view.layout;

import org.openvpms.component.business.service.archetype.handler.ArchetypeHandler;
import org.openvpms.component.business.service.archetype.handler.ShortNamePairArchetypeHandlers;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.web.component.im.layout.DefaultLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategy;
import org.openvpms.web.component.im.layout.IMObjectLayoutStrategyFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractLayoutStrategyFactory
implements IMObjectLayoutStrategyFactory {
    private final ArchetypeService service;
    private static final Logger log = LoggerFactory.getLogger(AbstractLayoutStrategyFactory.class);

    protected AbstractLayoutStrategyFactory(ArchetypeService service) {
        this.service = service;
    }

    @Override
    public IMObjectLayoutStrategy create(IMObject object) {
        return this.create(object, null);
    }

    @Override
    public IMObjectLayoutStrategy create(IMObject object, IMObject parent) {
        ArchetypeHandler handler;
        IMObjectLayoutStrategy result = null;
        if (parent != null) {
            String primary = object.getArchetype();
            String secondary = parent.getArchetype();
            handler = this.getStrategies().getHandler(primary, secondary);
        } else {
            String shortName = object.getArchetype();
            handler = this.getStrategies().getHandler(shortName);
        }
        if (handler != null) {
            try {
                result = (IMObjectLayoutStrategy)handler.create();
            }
            catch (Throwable throwable) {
                log.error(throwable.getMessage(), throwable);
            }
        }
        if (result == null) {
            result = new DefaultLayoutStrategy();
        }
        return result;
    }

    protected abstract ShortNamePairArchetypeHandlers getStrategies();

    protected ShortNamePairArchetypeHandlers load(String name) {
        return new ShortNamePairArchetypeHandlers(name, IMObjectLayoutStrategy.class, this.service);
    }
}

