/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view.act;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.collections.Transformer;
import org.openvpms.component.business.domain.im.act.ActRelationship;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.exception.OpenVPMSException;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.ArchetypeQuery;
import org.openvpms.component.system.common.query.BaseArchetypeConstraint;
import org.openvpms.component.system.common.query.IArchetypeQuery;
import org.openvpms.component.system.common.query.IConstraint;
import org.openvpms.component.system.common.query.IdConstraint;
import org.openvpms.component.system.common.query.NodeSelectConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.ObjectRefConstraint;
import org.openvpms.component.system.common.query.ObjectSet;
import org.openvpms.component.system.common.query.ObjectSetQueryIterator;
import org.openvpms.component.system.common.query.ShortNameConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.query.AbstractListResultSet;
import org.openvpms.web.component.im.query.QueryHelper;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.IMObjectSorter;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.component.util.ErrorHelper;
import org.openvpms.web.system.ServiceHelper;

public class ActRelationshipResultSet
extends AbstractListResultSet<IMObject> {
    private final Act parent;
    private final String[] relationshipShortNames;
    private final String[] shortNames;
    private SortConstraint[] sort = new SortConstraint[0];
    private boolean sortAscending = true;

    public ActRelationshipResultSet(Act parent, List<IMObject> relationships, String[] relationshipShortNames, int pageSize) {
        super(relationships, pageSize);
        this.parent = parent;
        this.relationshipShortNames = relationshipShortNames;
        this.shortNames = DescriptorHelper.getNodeShortNames((String[])relationshipShortNames, (String)"target", (ArchetypeService)ServiceHelper.getArchetypeService());
    }

    @Override
    public void sort(SortConstraint[] sort) {
        if (sort != null && sort.length != 0 && !this.getObjects().isEmpty()) {
            ArrayList<NodeSortConstraint> nodes = new ArrayList<NodeSortConstraint>();
            boolean memorySort = false;
            this.sortAscending = sort[0].isAscending();
            for (SortConstraint constraint : sort) {
                if (constraint instanceof VirtualNodeSortConstraint) {
                    memorySort = true;
                    break;
                }
                if (!(constraint instanceof NodeSortConstraint)) continue;
                nodes.add((NodeSortConstraint)constraint);
            }
            if (memorySort) {
                this.memorySort(sort);
            } else if (!nodes.isEmpty()) {
                this.querySort(nodes);
            }
            this.sort = sort;
        }
        this.reset();
    }

    @Override
    public boolean isSortedAscending() {
        return this.sortAscending;
    }

    @Override
    public SortConstraint[] getSortConstraints() {
        return this.sort;
    }

    protected void memorySort(SortConstraint[] sort) {
        IMObjectSorter.sort(this.getObjects(), sort, new Transformer(){

            public Object transform(Object input) {
                ActRelationship relationship = (ActRelationship)input;
                return IMObjectHelper.getObject((Reference)relationship.getTarget());
            }
        });
    }

    protected void querySort(List<NodeSortConstraint> nodes) {
        try {
            ArrayList<Object> sorted = new ArrayList<Object>();
            ArchetypeQuery query = this.createQuery(nodes);
            LinkedHashMap<Long, ActRelationship> relsById = new LinkedHashMap<Long, ActRelationship>();
            for (IMObject object : this.getObjects()) {
                relsById.put(object.getId(), (ActRelationship)object);
            }
            ObjectSetQueryIterator iter = new ObjectSetQueryIterator((IArchetypeQuery)query);
            while (iter.hasNext()) {
                ObjectSet set = (ObjectSet)iter.next();
                long id = set.getLong("rel.id");
                ActRelationship relationship = (ActRelationship)relsById.remove(id);
                if (relationship == null) continue;
                sorted.add(relationship);
            }
            for (IMObject relationship : relsById.values()) {
                sorted.add(relationship);
            }
            this.getObjects().clear();
            this.getObjects().addAll(sorted);
        }
        catch (OpenVPMSException exception) {
            ErrorHelper.show(exception);
        }
    }

    protected ArchetypeQuery createQuery(List<NodeSortConstraint> nodes) {
        ShortNameConstraint relationships = new ShortNameConstraint("rel", this.relationshipShortNames, false, false);
        ObjectRefConstraint source = new ObjectRefConstraint("source", this.parent.getObjectReference());
        ShortNameConstraint target = new ShortNameConstraint("target", this.shortNames, false, false);
        ArchetypeQuery query = new ArchetypeQuery((BaseArchetypeConstraint)relationships);
        query.setMaxResults(-1);
        query.add((IConstraint)source);
        query.add((IConstraint)target);
        query.add((IConstraint)new IdConstraint("rel.source", "source"));
        query.add((IConstraint)new IdConstraint("rel.target", "target"));
        query.add((IConstraint)new NodeSelectConstraint("rel.id"));
        for (NodeSortConstraint node : nodes) {
            String name = node.getNodeName();
            NodeDescriptor descriptor = QueryHelper.getDescriptor(target, name);
            if (descriptor == null) continue;
            if (QueryHelper.isParticipationNode(descriptor)) {
                QueryHelper.addSortOnParticipation(target, query, descriptor, node.isAscending());
                continue;
            }
            query.add((IConstraint)new NodeSortConstraint(target.getAlias(), name, node.isAscending()));
        }
        return query;
    }
}

