/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import java.util.List;
import nextapp.echo2.app.Component;
import nextapp.echo2.app.SplitPane;
import nextapp.echo2.app.button.AbstractButton;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.web.component.app.Context;
import org.openvpms.web.component.app.ContextSwitchListener;
import org.openvpms.web.component.im.layout.DefaultLayoutContext;
import org.openvpms.web.component.im.query.ResultSet;
import org.openvpms.web.component.im.query.ResultSetIterator;
import org.openvpms.web.component.im.view.IMObjectViewer;
import org.openvpms.web.component.im.view.IMObjectViewerDialog;
import org.openvpms.web.component.im.view.Selection;
import org.openvpms.web.echo.button.ButtonSet;
import org.openvpms.web.echo.dialog.PopupDialog;
import org.openvpms.web.echo.help.HelpContext;
import org.openvpms.web.echo.keyboard.KeyStrokeHelper;

public class ViewResultSetDialog<T extends IMObject>
extends PopupDialog {
    public static final String EDIT_ID = "edit";
    private final Context context;
    private final ContextSwitchListener listener;
    private final ResultSetIterator<T> iter;
    private IMObjectViewer viewer;
    private T selected;
    private static final String PREVIOUS_ID = "previous";
    private static final String NEXT_ID = "next";
    private static final String[] VIEW_BUTTONS = new String[]{"cancel", "previous", "next"};
    private static final String[] EDIT_BUTTONS = new String[]{"cancel", "edit", "previous", "next"};

    public ViewResultSetDialog(String title, T first, ResultSet<T> set, boolean edit, Context context, HelpContext help) {
        super(title, "IMObjectViewerDialog", edit ? EDIT_BUTTONS : VIEW_BUTTONS, help);
        this.context = context;
        this.setDefaultButton("ok");
        this.setDefaultCloseAction("cancel");
        this.iter = new ResultSetIterator<T>(set, first);
        this.listener = new ContextSwitchListener(){

            @Override
            public void switchTo(IMObject object) {
                ViewResultSetDialog.this.viewChild(object);
            }

            @Override
            public void switchTo(String shortName) {
            }
        };
        this.setModal(true);
        if (this.iter.hasNext()) {
            this.view((IMObject)this.iter.next(), null);
        }
        this.enableButtons(true, false);
    }

    public T getSelected() {
        return this.selected;
    }

    public List<Selection> getSelectionPath() {
        return this.viewer != null ? this.viewer.getSelectionPath() : null;
    }

    public HelpContext getHelpContext() {
        return this.viewer != null ? this.viewer.getHelpContext() : super.getHelpContext();
    }

    protected void onPrevious() {
        long id;
        long l = id = this.selected != null ? this.selected.getId() : -1L;
        if (this.iter.hasPrevious()) {
            IMObject object = (IMObject)this.iter.previous();
            if (object.getId() == id && this.iter.hasPrevious()) {
                object = (IMObject)this.iter.previous();
            }
            List<Selection> path = this.viewer != null ? this.viewer.getSelectionPath() : null;
            this.view(object, path);
            this.enableButtons(false, false);
        }
    }

    protected void onNext() {
        long id;
        long l = id = this.selected != null ? this.selected.getId() : -1L;
        if (this.iter.hasNext()) {
            IMObject object = (IMObject)this.iter.next();
            if (object.getId() == id && this.iter.hasNext()) {
                object = (IMObject)this.iter.next();
            }
            List<Selection> path = this.viewer != null ? this.viewer.getSelectionPath() : null;
            this.view(object, path);
            this.enableButtons(false, true);
        }
    }

    protected void onButton(String button) {
        if (PREVIOUS_ID.equals(button)) {
            this.onPrevious();
        } else if (NEXT_ID.equals(button)) {
            this.onNext();
        } else {
            super.onButton(button);
        }
    }

    protected void view(T object, List<Selection> path) {
        this.selected = object;
        HelpContext help = this.getHelpContext().topic(object, "view");
        DefaultLayoutContext context = new DefaultLayoutContext(this.context, help);
        context.getContext().setCurrent((IMObject)object);
        context.setContextSwitchListener(this.listener);
        IMObjectViewer viewer = new IMObjectViewer((IMObject)object, null, context);
        SplitPane pane = this.getLayout();
        if (this.viewer != null) {
            pane.remove(this.viewer.getComponent());
        }
        this.viewer = viewer;
        pane.add(this.viewer.getComponent());
        if (path != null) {
            viewer.setSelectionPath(path);
        }
    }

    private void enableButtons(boolean focusOK, boolean focusNext) {
        ButtonSet set = this.getButtons();
        AbstractButton ok = set.getButton("ok");
        AbstractButton previous = set.getButton(PREVIOUS_ID);
        AbstractButton next = set.getButton(NEXT_ID);
        previous.setEnabled(this.iter.lastIndex() > 0);
        next.setEnabled(this.iter.hasNext());
        if (focusOK) {
            this.setFocus((Component)ok);
        } else if (focusNext && next.isEnabled()) {
            this.setFocus((Component)next);
        } else if (previous.isEnabled()) {
            this.setFocus((Component)previous);
        } else {
            this.setFocus((Component)ok);
        }
        KeyStrokeHelper.reregisterKeyStrokeListeners((Component)this);
    }

    private void viewChild(IMObject object) {
        HelpContext help = this.getHelpContext().topic(object, "view");
        IMObjectViewerDialog dialog = new IMObjectViewerDialog(object, this.context, help);
        dialog.show();
    }
}

