/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.view;

import nextapp.echo2.app.Extent;

public class Hint {
    private final Extent width;
    private final Extent height;
    private final boolean multiline;

    private Hint(Builder builder) {
        this.width = builder.width;
        this.height = builder.height;
        this.multiline = builder.multiline;
    }

    public Extent getWidth() {
        return this.width;
    }

    public boolean useDefaultWidth() {
        return this.width == null;
    }

    public Extent getHeight() {
        return this.height;
    }

    public boolean useDefaultHeight() {
        return this.height == null;
    }

    public boolean singleRow() {
        return this.height != null && this.height.getValue() == 1 && (this.height.getUnits() == 128 || this.height.getUnits() == 64);
    }

    public boolean isMultiline() {
        return this.multiline;
    }

    public static Hint width(int width) {
        return Hint.newHint().width(width).build();
    }

    public static Hint width(Extent width) {
        return Hint.newHint().width(width).build();
    }

    public static Hint height(int height) {
        return Hint.newHint().height(height).build();
    }

    public static Hint size(int width, int height) {
        return Hint.newHint().width(width).height(height).build();
    }

    public static Hint multiline() {
        return Hint.newHint().multiline(true).build();
    }

    public static Builder newHint() {
        return new Builder();
    }

    public static class Builder {
        private Extent width;
        private Extent height;
        private boolean multiline;

        public Builder width(int width) {
            return this.width(width, 128);
        }

        public Builder width(int width, int units) {
            return this.width(new Extent(width, units));
        }

        public Builder width(Extent width) {
            this.width = width;
            return this;
        }

        public Builder height(int height) {
            return this.height(height, 64);
        }

        public Builder height(int height, int units) {
            return this.height(new Extent(height, units));
        }

        public Builder height(Extent height) {
            this.height = height;
            return this;
        }

        public Builder multiline(boolean multiline) {
            this.multiline = multiline;
            return this;
        }

        public Hint build() {
            return new Hint(this);
        }
    }
}

