/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.web.component.im.util;

import java.sql.Timestamp;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections.ComparatorUtils;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.comparators.ComparatorChain;
import org.apache.commons.collections.comparators.TransformingComparator;
import org.apache.commons.collections.functors.ChainedTransformer;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.DescriptorException;
import org.openvpms.component.business.domain.im.archetype.descriptor.NodeDescriptor;
import org.openvpms.component.business.service.archetype.CachingReadOnlyArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.DescriptorHelper;
import org.openvpms.component.business.service.archetype.helper.LookupHelper;
import org.openvpms.component.business.service.archetype.helper.NodeResolver;
import org.openvpms.component.model.act.Participation;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.query.ArchetypeSortConstraint;
import org.openvpms.component.system.common.query.NodeSortConstraint;
import org.openvpms.component.system.common.query.SortConstraint;
import org.openvpms.web.component.im.util.IMObjectHelper;
import org.openvpms.web.component.im.util.VirtualNodeSortConstraint;
import org.openvpms.web.system.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IMObjectSorter {
    private static final Logger log = LoggerFactory.getLogger(IMObjectSorter.class);

    public static <T extends IMObject> void sort(List<T> objects, String node, boolean ascending) {
        IMObjectSorter.sort(objects, new SortConstraint[]{new NodeSortConstraint(node, ascending)});
    }

    public static <T extends IMObject> void sort(List<T> objects, String ... nodes) {
        SortConstraint[] constraints = new SortConstraint[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            constraints[i] = new NodeSortConstraint(nodes[i]);
        }
        IMObjectSorter.sort(objects, constraints);
    }

    public static <T extends IMObject> void sort(List<T> objects, SortConstraint ... sort) {
        ComparatorFactory factory = new ComparatorFactory();
        Comparator comparator = factory.create(sort);
        Collections.sort(objects, comparator);
    }

    public static <T> void sort(List<T> objects, SortConstraint[] sort, Transformer transformer) {
        ComparatorFactory factory = new ComparatorFactory();
        Comparator comparator = factory.create(sort, transformer);
        Collections.sort(objects, comparator);
    }

    public static <T extends IMObject> Comparator<T> getNameComparator(boolean ascending) {
        Comparator comparator = IMObjectSorter.getComparator(ascending);
        return (o1, o2) -> comparator.compare(o1.getName(), o2.getName());
    }

    public static Comparator getComparator(boolean ascending) {
        Comparator comparator = ComparatorUtils.naturalComparator();
        comparator = ComparatorUtils.nullLowComparator((Comparator)comparator);
        if (!ascending) {
            comparator = ComparatorUtils.reversedComparator((Comparator)comparator);
        }
        return comparator;
    }

    protected static Object convert(Object value, IArchetypeService service) {
        if (value instanceof Participation) {
            Participation p = (Participation)value;
            value = IMObjectHelper.getName(p.getEntity(), service);
        } else if (!(value instanceof Comparable)) {
            value = null;
        } else if (value instanceof Timestamp) {
            value = new Date(((Timestamp)value).getTime());
        }
        return value;
    }

    private static class IdentityComparator
    implements Comparator {
        private static final Comparator INSTANCE = new IdentityComparator();

        private IdentityComparator() {
        }

        public int compare(Object o1, Object o2) {
            int hash1 = System.identityHashCode(o1);
            int hash2 = System.identityHashCode(o2);
            return hash1 - hash2;
        }
    }

    private static class ArchetypeTransformer
    implements Transformer {
        private ArchetypeTransformer() {
        }

        public Object transform(Object input) {
            if (input != null) {
                IMObject object = (IMObject)input;
                return object.getArchetype();
            }
            return null;
        }
    }

    private static class NodeTransformer
    implements Transformer {
        private final String node;
        private final IArchetypeService service;
        private ArchetypeDescriptor archetype;
        private NodeDescriptor descriptor;

        public NodeTransformer(String node, IArchetypeService service) {
            this.node = node;
            this.service = service;
        }

        public Object transform(Object input) {
            IMObject object;
            NodeDescriptor descriptor;
            Object result = null;
            if (input != null && (descriptor = this.getDescriptor(object = (IMObject)input)) != null) {
                try {
                    if (descriptor.isCollection()) {
                        List objects = descriptor.getValues(object);
                        if (objects.size() == 1) {
                            result = objects.get(0);
                        }
                    } else {
                        result = descriptor.isLookup() ? LookupHelper.getName((ArchetypeService)this.service, (LookupService)ServiceHelper.getLookupService(), (IMObject)object, (String)descriptor.getName()) : descriptor.getValue(object);
                    }
                    result = IMObjectSorter.convert(result, this.service);
                }
                catch (DescriptorException exception) {
                    log.error(exception.getMessage(), (Throwable)exception);
                }
            }
            return result;
        }

        private NodeDescriptor getDescriptor(IMObject object) {
            if (this.archetype == null || !this.archetype.getArchetypeType().equals(object.getArchetype())) {
                this.archetype = DescriptorHelper.getArchetypeDescriptor((IMObject)object, (ArchetypeService)ServiceHelper.getArchetypeService());
                if (this.archetype == null) {
                    throw new IllegalStateException("No archetype descriptor found for object, id=" + object.getId() + ", archetype=" + object.getArchetype());
                }
                this.descriptor = this.archetype.getNodeDescriptor(this.node);
            }
            return this.descriptor;
        }
    }

    private static class NodeResolverTransformer
    implements Transformer {
        private final String node;
        private final IArchetypeService service;

        public NodeResolverTransformer(String node, IArchetypeService service) {
            this.node = node;
            this.service = service;
        }

        public Object transform(Object input) {
            IMObject object = (IMObject)input;
            if (object != null) {
                NodeResolver resolver = new NodeResolver(object, (ArchetypeService)this.service);
                Object value = resolver.getObject(this.node);
                return IMObjectSorter.convert(value, this.service);
            }
            return null;
        }
    }

    private static class ComparatorFactory {
        private IArchetypeService service;

        private ComparatorFactory() {
        }

        public Comparator create(SortConstraint[] sort) {
            ComparatorChain comparator = new ComparatorChain();
            for (SortConstraint constraint : sort) {
                Comparator<Object> node;
                if (constraint instanceof VirtualNodeSortConstraint) {
                    node = this.getComparator((VirtualNodeSortConstraint)constraint);
                    comparator.addComparator(node);
                    continue;
                }
                if (constraint instanceof NodeSortConstraint) {
                    node = this.getComparator((NodeSortConstraint)constraint);
                    comparator.addComparator(node);
                    continue;
                }
                if (!(constraint instanceof ArchetypeSortConstraint)) continue;
                Comparator<Object> type = this.getComparator((ArchetypeSortConstraint)constraint);
                comparator.addComparator(type);
                break;
            }
            comparator.addComparator(IdentityComparator.INSTANCE);
            return comparator;
        }

        public Comparator create(SortConstraint[] sort, Transformer transformer) {
            ComparatorChain comparator = new ComparatorChain();
            for (SortConstraint constraint : sort) {
                Comparator<Object> node;
                if (constraint instanceof VirtualNodeSortConstraint) {
                    node = this.getComparator((VirtualNodeSortConstraint)constraint, transformer);
                    comparator.addComparator(node);
                    continue;
                }
                if (constraint instanceof NodeSortConstraint) {
                    node = this.getComparator((NodeSortConstraint)constraint, transformer);
                    comparator.addComparator(node);
                    continue;
                }
                if (!(constraint instanceof ArchetypeSortConstraint)) continue;
                Comparator<Object> type = this.getComparator((ArchetypeSortConstraint)constraint, transformer);
                comparator.addComparator(type);
                break;
            }
            comparator.addComparator(IdentityComparator.INSTANCE);
            return comparator;
        }

        private Comparator<Object> getComparator(VirtualNodeSortConstraint sort) {
            Comparator comparator = IMObjectSorter.getComparator(sort.isAscending());
            Transformer transformer = sort.getTransformer();
            if (transformer == null) {
                transformer = this.getTransformer(sort);
            }
            return new TransformingComparator(transformer, comparator);
        }

        private Comparator<Object> getComparator(VirtualNodeSortConstraint sort, Transformer transformer) {
            TransformingComparator comparator = this.getComparator(sort);
            return sort.getTransformer() == null ? new TransformingComparator(transformer, (Comparator)comparator) : comparator;
        }

        private Comparator<Object> getComparator(NodeSortConstraint sort) {
            Comparator comparator = IMObjectSorter.getComparator(sort.isAscending());
            Transformer transformer = this.getTransformer(sort);
            return new TransformingComparator(transformer, comparator);
        }

        private Comparator<Object> getComparator(NodeSortConstraint sort, Transformer transformer) {
            Comparator comparator = IMObjectSorter.getComparator(sort.isAscending());
            Transformer transform = ChainedTransformer.getInstance((Transformer)transformer, (Transformer)this.getTransformer(sort));
            return new TransformingComparator(transform, comparator);
        }

        private Comparator<Object> getComparator(ArchetypeSortConstraint sort) {
            Comparator comparator = IMObjectSorter.getComparator(sort.isAscending());
            ArchetypeTransformer transformer = new ArchetypeTransformer();
            return new TransformingComparator((Transformer)transformer, comparator);
        }

        private Comparator<Object> getComparator(ArchetypeSortConstraint sort, Transformer transformer) {
            Comparator comparator = IMObjectSorter.getComparator(sort.isAscending());
            Transformer transform = ChainedTransformer.getInstance((Transformer)transformer, (Transformer)new ArchetypeTransformer());
            return new TransformingComparator(transform, comparator);
        }

        private Transformer getTransformer(NodeSortConstraint sort) {
            IArchetypeService service = this.getService();
            String name = sort.getNodeName();
            if (name.contains(".")) {
                return new NodeResolverTransformer(name, service);
            }
            return new NodeTransformer(name, service);
        }

        private IArchetypeService getService() {
            if (this.service == null) {
                this.service = new CachingReadOnlyArchetypeService(100, (IArchetypeService)ServiceHelper.getArchetypeService());
            }
            return this.service;
        }
    }
}

